<?php
use App\Http\Controllers\CabinetController;
use App\Http\Controllers\BackupController;
use App\Http\Controllers\BelanceController;
use App\Http\Controllers\BenefitController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ExchangeController;
use App\Http\Controllers\ExpenseCategoryController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\GoldRateController;
use App\Http\Controllers\CabinStockController;
use App\Http\Controllers\PurchaseReportController;
use App\Http\Controllers\SallesDashboardController;
use App\Http\Controllers\TransferReportController;
use App\Http\Controllers\GoldRateTimeController;
use App\Http\Controllers\ImportDatabase;
use App\Http\Controllers\RetrunPurchaseBillController;
use App\Http\Controllers\ReturnSellBillController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\TransformationController;
use Doctrine\Inflector\Rules\Transformations;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AccountsController;
use App\Http\Controllers\BelancesController;
use App\Http\Controllers\ItemsController;
use App\Http\Controllers\ItemTypesController;
use App\Http\Controllers\MoneysController;
use App\Http\Controllers\PurchasesController;
use App\Http\Controllers\ReportsController;
use App\Http\Controllers\SellsController;
use App\Http\Controllers\ternary;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\SidebarController;
use App\Http\Controllers\StocksController;
use App\Http\Controllers\UserActivityLogsController;
use App\Http\Controllers\UsersController;
use App\Http\Controllers\RateController;
use App\Http\Controllers\EmptySelectedTablesController;
use App\Http\Controllers\SiteSettingController;
use App\Http\Controllers\RBACController;




use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use Illuminate\Validation\ValidationException;

use App\Http\Controllers\Api\AuthController;

Route::middleware('auth:sanctum')->group(function () {
    Route::resource('customers', AccountsController::class);
    Route::apiResource('site-settings', SiteSettingController::class);
    Route::resource('belance', BelancesController::class);
    Route::resource('item',  ItemsController::class);
    Route::resource('itemtype', ItemTypesController::class);
    Route::resource('money', MoneysController::class);
    Route::resource('purchase', PurchasesController::class);
    Route::get('dashboard', [ DashboardController::class,'getDashboard']);
    Route::resource('report', ReportsController::class);
    Route::get('commession', [ BelancesController::class,'getcomesion']);
    Route::get('reports/sum_by_money_type', [ternary::class, 'index']); 
    Route::get('reports/get_last_report_id',[ ReportsController::class,'getLastReportId']);
    Route::get('report/checkbelance', [ReportsController::class,'checkBalance']);
    Route::resource('sellreturn', ReturnSellBillController::class);
    Route::resource('purchasereturn', RetrunPurchaseBillController::class);
    Route::resource('sell', SellsController::class);
    Route::resource('gold', GoldRateTimeController::class);
    Route::resource('settings', SettingsController::class);
    Route::resource('stock', StocksController::class);
    Route::resource('cabin', CabinetController::class);
    Route::get('getcobin/{id}',[ CabinetController::class,'getItemsByCabinet']);
    Route::resource('user', UsersController::class);
    Route::resource('expense/category', ExpenseCategoryController::class);
    Route::resource('expense', ExpenseController::class);
    Route::resource('transformations', TransformationController::class);
    Route::post('/empty-selected-tables', [EmptySelectedTablesController::class, 'emptyTables'])->middleware('auth:api');
    Route::get('/backup', [BackupController::class, 'backupDatabase']);
    Route::post('/import', [ImportDatabase::class, 'importDatabase']);
    Route::resource('benefitcontroller', BenefitController::class);
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::get('/permissions', [RBACController::class, 'getAllPermissions']);
    Route::post('/cabin-stocks-transfer', [CabinStockController::class, 'transfer']); 


    Route::get('/belances/export', [BelancesController::class, 'exportExcel']);


    Route::resource('rate', RateController::class)->only([
        'index', 'store', 'show', 'update', 'destroy'
    ]);
    Route::resource('sidebar', SidebarController::class)->only([
        'index', 'store', 'show', 'update', 'destroy'
    ]); 
});
// routes/web.php یا routes/api.php
Route::get('getImage/{image}', function ($image) {
    // مسیر تصویر را به دست می‌آوریم
    $usePublicPath = env('UPLOAD_USE_PUBLIC_PATH', true);
    
    $path = $usePublicPath
    ? public_path("company_pic/{$image}")
    : $_SERVER['DOCUMENT_ROOT'] . '/company_pic/' . $image;// چک می‌کنیم که آیا فایل وجود دارد یا خیر
    if (!file_exists($path)) {
        return response()->json(['error' => 'Image not found'], 404);
    }
    
    // ارسال تصویر به صورت مستقیم (در اینجا فایل در همان مسیر public قرار دارد)
    return response()->file($path);
});
Route::get('/first-setting', [SettingsController::class, 'getFirstSettingValue']);
Route::post('/login', [AuthController::class, 'login']); 
Route::get('/settings',[ SettingsController::class,'index']);

// Route::get('/roles', [RBACController::class, 'getRolesWithPermissions']);
// Route::group([
//     'prefix' => 'users',
// ], function () {
//     Route::get('/', [UsersController::class, 'index'])
//          ->name('users.user.index');
//     Route::get('/create', [UsersController::class, 'create'])
//          ->name('users.user.create');
//     Route::get('/show/{user}',[UsersController::class, 'show'])
//          ->name('users.user.show')->where('id', '[0-9]+');
//     Route::get('/{user}/edit',[UsersController::class, 'edit'])
//          ->name('users.user.edit')->where('id', '[0-9]+');
    // Route::post('/', [UsersController::class, 'store'])
    //      ->name('users.user.store');
    //     Route::put('user/{user}', [UsersController::class, 'update'])
//          ->name('users.user.update')->where('id', '[0-9]+');
//     Route::delete('/user/{user}',[UsersController::class, 'destroy'])
//          ->name('users.user.destroy')->where('id', '[0-9]+');
// })
// ;



// routes/api.php

Route::prefix('transfer-reports')->group(function () {
    Route::get('/', [TransferReportController::class, 'index']);
    Route::get('/form-data', [TransferReportController::class, 'getFormData']);
    Route::get('/export', [TransferReportController::class, 'export']);
    Route::post('/', [TransferReportController::class, 'store']);
    Route::get('/{id}', [TransferReportController::class, 'show']);
    Route::put('/{id}', [TransferReportController::class, 'update']);
    Route::delete('/{id}', [TransferReportController::class, 'destroy']);
});

Route::Resource('/exchange',ExchangeController::class);
Route::get('/dashboard/data', [SallesDashboardController::class, 'getDashboardData']);


//purchase report
Route::Resource('purchase-items', PurchaseReportController::class);
Route::get('purchase-items-statistics', [PurchaseReportController::class, 'getStatistics']);


    Route::Resource('cabin-stocks', CabinStockController::class);
    Route::get('cabin-stocks-form-data', [CabinStockController::class, 'getFormData']);
    Route::post('cabin-stocks-search', [CabinStockController::class, 'search']);
    Route::resource('/roles', RoleController::class);
    Route::group([
    'prefix' => 'user_activity_logs',
], function () {
    //     Route::get('/', [UserActivityLogsController::class, 'index'])
    //          ->name('user_activity_logs.user_activity_log.index');
    //     Route::get('/create', [UserActivityLogsController::class, 'create'])
    //          ->name('user_activity_logs.user_activity_log.create');
    //     Route::get('/show/{userActivityLog}',[UserActivityLogsController::class, 'show'])
    //          ->name('user_activity_logs.user_activity_log.show')->where('id', '[0-9]+');
    //     Route::get('/{userActivityLog}/edit',[UserActivityLogsController::class, 'edit'])
//          ->name('user_activity_logs.user_activity_log.edit')->where('id', '[0-9]+');
//     Route::post('/', [UserActivityLogsController::class, 'store'])
//          ->name('user_activity_logs.user_activity_log.store');
//     Route::put('user_activity_log/{userActivityLog}', [UserActivityLogsController::class, 'update'])
//          ->name('user_activity_logs.user_activity_log.update')->where('id', '[0-9]+');
//     Route::delete('/user_activity_log/{userActivityLog}',[UserActivityLogsController::class, 'destroy'])
//          ->name('user_activity_logs.user_activity_log.destroy')->where('id', '[0-9]+');
});