<?php
// database/migrations/2023_01_01_create_transfer_reports_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('transfer_reports', function (Blueprint $table) {
            $table->id();
            $table->foreignId('item_id')->constrained('items')->onDelete('cascade');
            $table->foreignId('from_cabin_id')->constrained('cabinets')->onDelete('cascade');
            $table->foreignId('to_cabin_id')->constrained('cabinets')->onDelete('cascade');
            $table->integer('quantity');
            $table->string('status')->default('completed'); // completed, pending, failed
            $table->foreignId('initiated_by')->constrained('users')->onDelete('cascade');
            $table->text('notes')->nullable();
            $table->timestamp('transfer_date')->useCurrent();
            $table->timestamp('completed_at')->nullable();
            $table->timestamps();
            
            // Indexes for better performance
            $table->index('transfer_date');
            $table->index('status');
            $table->index(['from_cabin_id', 'to_cabin_id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('transfer_reports');
    }
};