<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       Schema::create('cabin_stocks', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('item_id');
            $table->unsignedBigInteger('cobin_id')->nullable();
            $table->integer('qty')->nullable();
            $table->decimal('weight', 64, 3)->nullable();
            $table->timestamp('dateInsert')->nullable();
            $table->integer('rate')->nullable();
            $table->unsignedBigInteger('user_id');
            $table->integer('purchase_price')->nullable();
            $table->timestamp('expiry_date')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();
            $table->unsignedBigInteger('money_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cabin_stocks');
    }
};
