<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('gold_rate_times', function (Blueprint $table) {
            $table->id();
            $table->date('date')->comment('Date of the gold rate');
            $table->unsignedBigInteger('user_id')->comment('ID of the user who created the record');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('gold_rate_times');
    }
};
