<?php

namespace App\Providers;


use App\Models\Accounts;
use App\Models\cabinet;
use App\Models\SiteSetting;
use Illuminate\Support\Facades\Hash;

use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Route;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use App\Models\User;
use App\Models\Settings;
class AppServiceProvider extends ServiceProvider
{
    /**
     * The path to the "home" route for your application.
     *
     * @var string
     */
    public const HOME = '/home';

    /**
     * Define your route model bindings, pattern filters, etc.
     */
    public function boot(): void
    {
        

if(Permission::count()===0){
$tables = [
  'accounts',
  'belances',
  'bills',
  'cabinets',
  'exchangetimes',
  'expense_categories',
  'expenses',
  'gold_rate_times',
  'gold_rates',
  'item_types',
  'items',
  'moneys',
  'posts',
  'purchasebills',
  'purchases',
  'rates',
  'reports',
  'returnpurchasebills',
  'returnpurchases',
  'returnsellbills',
  'returnsells',
  'sells',
  'settings',
  'sidebars',
  'site_settings',
  'user_activity_logs',
  'users'
];

foreach ($tables as $table) {
    Permission::firstOrCreate(['name' => "view $table"]);
    Permission::firstOrCreate(['name' => "create $table"]);
    Permission::firstOrCreate(['name' => "edit $table"]);
    Permission::firstOrCreate(['name' => "delete $table"]);
}
$admin = Role::firstOrCreate(['name' => 'admin']);
$allPermissions = Permission::all();
$admin->syncPermissions($allPermissions);
$user = User::find(1);
$user->assignRole('admin');

}


        if (SiteSetting::count() === 0) {
            SiteSetting::create([
                // ['key', 'value', 'type', 'description']
                'key' => '1',
                'value' => 'afg',
                'description' =>'money', // رمز عبور
            ]);
            SiteSetting::create([
                'key' => 'desc',
                'value' => 'id',
                'description' =>'', // رمز عبور
            ]);
        }
        if (User::count() === 0) {
            User::create([
                'name' => 'admin',
                'category' => 'admin',
                'password' => Hash::make('password'), // رمز عبور
            ]);
        }
        if(Accounts::count()===0){
            Accounts::create([
                'name'=>'Owner',
                'user_id'=>User::first()->id,
               'ontransaction'=>1, 
            ]);
        }
        if (Settings::count() === 0) {
            Settings::create([
'language' => 'English',
                'date' => 'English',
                'company_pic'=>'null',
                'company_name'=>'Company Name',
                'description'=>'description',
                'address'=>'address',
                'phone'=>'phone',
                'email'=>'exaple@example.com',            ]);
        }

        if (cabinet::count() === 0) {
            cabinet::create([
           'name'=>"Main Shoping"
           , 'location'=>"New in shop"
           , 'description'=>"this is a new Cabinet"
            ]);
        }

        $this->configureRateLimiting();

        $this->routes(function () {
            Route::middleware('api')
                ->prefix('api')
                ->group(base_path('routes/api.php')); // روت‌های API از این فایل خوانده می‌شوند

            Route::middleware('web')
                ->group(base_path('routes/web.php')); // روت‌های وب از این فایل خوانده می‌شوند
        });
    }

    /**
     * Configure the rate limiters for the application.
     */
    protected function configureRateLimiting(): void
    {
        \Illuminate\Support\Facades\RateLimiter::for('api', function (\Illuminate\Http\Request $request) {
            return \Illuminate\Cache\RateLimiting\Limit::perMinute(60)->by($request->user()?->id ?: $request->ip());
        });
    }
}
