<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
class Purchase extends Model
{
    use HasFactory;

    protected $fillable = [
        'stocks_id',
        'qty',
        'weight',
        'dateInsert',
        'rate',
        'user_id',
        'isdelete',
        'purchase_price',
        'sell_price',
        'expiry_date',
        'description',
        'bill_id',
        'money_id',
        'remainqty',
        'insell',
        'cobin_id',
        "purchase_money_id"
    ];

    public function stock()
    {
        return $this->belongsTo(Item::class, 'stocks_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function bill()
    {
        return $this->belongsTo(Purchasebills::class,'bill_id');
    }
    public function cobin(){
        return $this->belongsTo(Cabinet::class,'cobin_id');
    }

    public function money(){
        return $this->belongsTo(Moneys::class,'money_id');
    }
}