<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Expense extends Model
{
    use HasFactory;
    protected $fillable = [
        'amount',
        'ex_cat',
        'money_id',
        'description',
        'date',
        'user_id',
        'isdelete',
    ];
    public function category()
    {
        return $this->belongsTo(ExpenseCategory::class, 'ex_cat');
    }
    public function money()
    {
        return $this->belongsTo(Moneys::class, 'money_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
