<?php

namespace App\Http\Middleware;

use Closure;

class ConvertNumericStrings
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $response = $next($request);
        
        // فقط برای پاسخ‌های JSON این تبدیل را انجام بده
        if ($response instanceof \Illuminate\Http\JsonResponse) {
            $data = $response->getData(true);
            $convertedData = $this->convertNumericStrings($data);
            $response->setData($convertedData);
        }
        
        return $response;
    }
    
    /**
     * تبدیل رشته‌های عددی به عدد
     *
     * @param  mixed  $data
     * @return mixed
     */
    protected function convertNumericStrings($data)
    {
        if (is_array($data)) {
            foreach ($data as $key => $value) {
                $data[$key] = $this->convertNumericStrings($value);
            }
            return $data;
        }
        
        if (is_object($data)) {
            foreach ($data as $key => $value) {
                $data->{$key} = $this->convertNumericStrings($value);
            }
            return $data;
        }
        
        // اگر رشته است و مقدار عددی دارد، تبدیل کن
        if (is_string($data)) {
            // بررسی آیا رشته عددی است (اعشاری و منفی هم پشتیبانی شود)
            if (is_numeric($data)) {
                // اگر عدد اعشاری است float برگردان، در غیر این صورت int
                return strpos($data, '.') !== false ? (float)$data : (int)$data;
            }
            
            // بررسی برای مقادیر boolean که به صورت رشته هستند
            if ($data === 'true') return true;
            if ($data === 'false') return false;
            if ($data === 'null') return null;
        }
        
        return $data;
    }
}