<?php

namespace App\Http\Controllers;

use App\Http\Resources\BelanceResource;
use App\Http\Resources\ReportResource;
use App\Http\Resources\toTransformations;
use GuzzleHttp\Promise\Create;
use Illuminate\Http\Request;
use App\Models\Accounts;
use App\Models\Report;
use App\Models\User;
use App\Models\Belances;
use Carbon\Carbon;
use Exception;

class TransformationController extends Controller
{
    // لیست گزارش‌ها
   public function index(Request $request)
{
    $perPage = (int) $request->query('perPage', 10);
    $currentPage = (int) $request->query('page', 1);
    $IsAll = $request->query('all');
    $search = $request->query('search');
    $startDate = $request->input('StartDate');
    $endDate = $request->input('EndDate');
    $user_id = $request->input('user_id', false);
    $isdelete = $request->input('isdelete');

    // دریافت گزارش‌ها با روابط مورد نیاز و فیلتر نوع
    $query = Report::with(['user', 'account.type', 'account.account'])->where('transformation','!=','null');
    
    if ($user_id && $user_id != '0') {
        $query->where('user_id', $user_id);
    }
    
    if ($startDate && $endDate) {
        $startDatestr = Carbon::parse($startDate)->startOfDay();
        $endDatestr = Carbon::parse($endDate)->endOfDay();
        $query->whereBetween('date_created', [$startDatestr, $endDatestr]);
    } else if ($startDate) {
        $startDatestr = Carbon::parse($startDate)->startOfDay();
        $query->whereDate('date_created', '=', $startDatestr);
    }
    
    if ($search !== 'false') {
        $transformations = Report::whereHas('account.account', function ($q) use ($search) {
            $q->where('name', 'like', "%$search%");
        })->pluck('transformation');
        
        $query->whereIn('transformation', $transformations);
    }
    
    $query = $query->where('isdelete', $isdelete)
        ->whereIn('type', ['from', 'to', 'com'])
        ->orderBy('date_created', 'desc');
    
    // گروه‌بندی و ساختاردهی داده‌ها به صورت مجموعه‌ای
    $groupedReports = $query->get()->groupBy('transformation')->map(function ($group): array {
        $account_id_from = $group->firstWhere('type', 'from') ? $group->firstWhere('type', 'from')->account_id : null;
        $account_id_to = $group->firstWhere('type', 'to') ? $group->firstWhere('type', 'to')->account_id : null;
        $account_id_com = $group->firstWhere('type', 'com') ? $group->firstWhere('type', 'com')->account_id : null;
        
        $balanceFrom = Belances::where('id', $account_id_from)
                             ->select('belance')
                             ->first();
        
        $balanceTo = Belances::where('id', $account_id_to)
                           ->select('belance')
                           ->first();
        
        $balanceCom = Belances::where('id', $account_id_com)
                           ->select('belance')
                           ->first();
        
        return [
            'belance' => [
                'from' => $balanceFrom,
                'to' => $balanceTo,
                'com' => $balanceCom
            ],
            'to' => $group->firstWhere('type', 'to') ? new toTransformations($group->firstWhere('type', 'to')) : null,
            'from' => $group->firstWhere('type', 'from') ? new ReportResource($group->firstWhere('type', 'from')) : null,
            'com' => $group->firstWhere('type', 'com') ? new ReportResource($group->firstWhere('type', 'com')) : null,
        ];
    })->filter(function ($group) {
        return $group['to'] || $group['from'] || $group['com'];
    });
    
    // Check if all parameter is set to "ok"
    if ($IsAll === 'ok') {
        return response()->json([
            'total' => $groupedReports->count(),
            'data' => $groupedReports->values(),
        ], 200);
    }
    
    // Normal pagination if all is not "ok"
    $total = $groupedReports->count();
    $paginatedReports = $groupedReports->forPage($currentPage, $perPage)->values();
    
    $groupedReportsPaginator = new \Illuminate\Pagination\LengthAwarePaginator(
        $paginatedReports,
        $total,
        $perPage,
        $currentPage,
        ['path' => $request->url()]
    );
    
    return response()->json([
        'total' => $groupedReportsPaginator->total(),
        'current_page' => $groupedReportsPaginator->currentPage(),
        'per_page' => $groupedReportsPaginator->perPage(),
        'last_page' => $groupedReportsPaginator->lastPage(),
        'data' => $groupedReportsPaginator->items(),
    ], 200);
}
        

          // ذخیره یک گزارش جدید
    public function store(Request $request)
    {

        $checkto = $request->get('checkto');
        $checkco = $request->get('checkco');
        $comesion = $request->get('complete');
        $data = $this->getData($request);
        if ($comesion === 'ok') {
            $belancefrom = Belances::where('id', $data['from_account_id'])->first();
            $belancefrom->belance -= (int)$data['from_amount'];
            $belancefrom->save();
            // 
            $belanceto = Belances::where('id', $data['to_account_id'])->first();
            $belanceto->belance += (int)$data['to_amount'];
            $belanceto->save();
            $customer=Accounts::where('id',$belanceto->account_id)->where('serial','>',0)->first();
            if($customer){
                $customer->serial+=1;
                $customer->save();
            }
            // 
            $belancecom = Belances::where('id', $data['com_account_id'])->first();
            $belancecom->belance += (int)$data['from_amount'] - (int)$data['to_amount'];
            $belancecom->save();
            // $data['date_creation'] = rtrim($data['date_creation'], 'Z') . '+00:00';
            $data['date_creation'] = Carbon::parse($data['date_creation'])->format('Y-m-d H:i:s');

            $report = Report::create([
                'user_id' => $data['user_id'],
                'discription' => $data['from_description'],
                'amount' => $data['from_amount'],
                'date_created' => $data['date_creation'],
                'type' => 'from',
                'account_id' => $data['from_account_id'],
                // 'cach'=>$belancefrom->belance
            ]);
            $new = Report::where('id', $report->id)->first();
            $new->transformation = $report->id;
            $new->save();
            // 
            $to = Report::create([
                'user_id' => $data['user_id'],
                'discription' => $checkto==='ok' ? $data['to_description']: $data['from_description'],
                'amount' => $data['to_amount'],
                'date_created' =>  $data['date_creation'],
                'type' => 'to',
                'account_id' => $data['to_account_id'],
                'transformation' => $report->id,
                // 'cach'=>$belanceto->belance
                
            ]);
            $com = Report::create([
                'user_id' => $data['user_id'],
                'discription' => $checkco==='ok' ?  $data['com_description']: $data['from_description'],
                'amount' => (int)$data['from_amount'] - (int)$data['to_amount'],
                'date_created' => $data['date_creation'],
                'type' => 'com',
                'account_id' => $data['com_account_id'],
                'transformation' => $report['id'],
                // 'cach'=>$belancecom->belance
            ]);
            return response()->json(['bill'=>['from' => $report, 'to' => $to, 'com' => $com,], 'belancecom' => $belancecom, 'belanceto' => $belanceto, 'belancefrom' => $belancefrom, 'belancecom_report' => new BelanceResource($belancecom), 'belanceto_report' => new BelanceResource($belanceto), 'belancefrom_report' => new BelanceResource($belancefrom)]);
            // 
        } else {
            $belancefrom = Belances::where('id', $data['from_account_id'])->first();
            $belancefrom->belance -= (int)$data['from_amount'];
            $belancefrom->save();
            // 
            $belanceto = Belances::where('id', $data['to_account_id'])->first();
            $belanceto->belance += (int)$data['to_amount'];
            $belanceto->save();
            $customer=Accounts::where('id',$belanceto->account_id)->where('serial','>',0)->first();
            if($customer){
                $customer->serial+=1;
                $customer->save();
            }
            $data['date_creation'] = Carbon::parse($data['date_creation'])->format('Y-m-d H:i:s');

            // 
            $report = Report::create([
                'user_id' => $data['user_id'],
                'discription' => $data['from_description'],
                'amount' => $data['from_amount'],
                'type' => 'from',
                'date_created' => $data['date_creation'],
                'account_id' => $data['from_account_id'],
                // 'cach'=>$belancefrom->belance

            ]);
            $new = Report::where('id', $report->id)->first();
            $new->transformation = $report->id;
            $new->save();
            // 
            $to = Report::create([
                'user_id' => $data['user_id'],
                'discription' => $checkto==='ok' ? $data['to_description']: $data['from_description'],
                'amount' => $data['to_amount'],
                'date_created' => $data['date_creation'],
                'type' => 'to',
                'account_id' => $data['to_account_id'],
                'transformation' => $report->id,
                // 'cach'=>$belanceto->belance
            ]);
            return response()->json(['bill'=>['from' => $report, 'to' => $to], 'belancefrom' => $belancefrom, 
            'belanceto' => $belanceto, 'belanceto_report' => new BelanceResource($belanceto),
             'belancefrom_report' => new BelanceResource($belancefrom)]);

        }
    }
    // نمایش یک گزارش
    public function show($id)
    {
        $report = Report::with('user', 'account')->find($id);

        if ($report) {
            return response()->json($report, 200);
        } else {
            return response()->json(['error' => 'Report not found'], 404);
        }
    }

    // به‌روزرسانی یک گزارش
    public function update($id, Request $request)
    {
        $old=$request->get('old');
        $type=$request->get('delete');
        $com=$request->get('complete');
        $comnew=$request->get('new');
        
        if($type==='delete'){
            $data= $request->validate([
                'from_id' => 'required',
                'from_account' => 'required',
                'from_amount' => 'required',
                'to_id' => 'required',
                'to_account' => 'required',
                'to_amount' => 'required',
                'com_id' => 'nullable',
                'com_account' => 'nullable',
                'com_amount' => 'nullable',
            ]);
            if($com==='ok'){
                $belancefrom = Belances::where('id', $data['from_account'])->first();
                $belancefrom->belance += (int)$data['from_amount'];
                $belancefrom->save();
                // 
                $belanceto = Belances::where('id', $data['to_account'])->first();
                $belanceto->belance -= (int)$data['to_amount'];
                $belanceto->save();
                // 
                $belancecom = Belances::where('id', $data['com_account'])->first();
                $belancecom->belance -= (int)$data['from_amount'] - $data['to_amount'];
                $belancecom->save();

                $report = Report::where('id', $data['from_id'])->first();
                $report->isdelete=1;
                $report->save();
                $report = Report::where('id', $data['to_id'])->first();
                $report->isdelete=1;
                $report->save();
                $report = Report::where('id', $data['com_id'])->first();
                $report->isdelete=1;
                $report->save();
                return response()->json(['belancecom_report' => new BelanceResource($belancecom), 'belanceto_report' => new BelanceResource($belanceto), 'belancefrom_report' => new BelanceResource($belancefrom)]);          
            }else{
                $belancefrom = Belances::where('id', $data['from_account'])->first();
                $belancefrom->belance += (int)$data['from_amount'];
                $belancefrom->save();
                // 
                $belanceto = Belances::where('id', $data['to_account'])->first();
                $belanceto->belance -= (int)$data['to_amount'];
                $belanceto->save();
                // 
                $report = Report::where('id', $data['from_id'])->first();
                $report->isdelete=1;
                $report->save();
                $report = Report::where('id', $data['to_id'])->first();
                $report->isdelete=1;
                $report->save();
                return response()->json(['belanceto_report' => new BelanceResource($belanceto), 'belancefrom_report' => new BelanceResource($belancefrom)]);
            }
        }else{
            $data = $this->getData($request);
            if($com==='ok'){
                 if (isset($data['date_creation'])) {
                    // Convert any format to MySQL datetime format
                    $data['date_creation'] = Carbon::parse($data['date_creation'])->format('Y-m-d H:i:s');
                }
                $oldreportfrom = Report::where('transformation', $id)->where('type','from')->first();
                $oldreportto = Report::where('transformation', $id)->where('type','to')->first();
                $oldreportcom = Report::where('transformation', $id)->where('type','com')->first();
                $oldbelancecom=null;
                if($old=="ok"){
                    $oldbelancecom = Belances::where('id', $oldreportcom->account_id)->first();
                $oldbelancecom->belance -= (int)$oldreportfrom->amount - (int)$oldreportto->amount;
                $oldbelancecom->save();
                $oldreportcom->discription = $data['com_description'];
                $oldreportcom->amount = (int)$data['from_amount'] - (int)$data['to_amount'];
                $oldreportcom->date_created = $data['date_creation'];
                // 'type' => 'com',
                $oldreportcom->account_id = $data['com_account_id'];
                $oldreportcom->save();
                // 'transformation' =$report['id']
                // $oldreportcom->cach=$belancecom->belance;
            // ]);
                }else{
                    // if(!$oldreportcom){
                        if($comnew){
                         $oldreportcom=Report::create([
                                'user_id' => $data['user_id'],
                                // 'discription' => $data['com_description'],
                                'amount' => $data['from_amount'] - $data['to_amount'],
                                'date_created' => $data['date_creation'],
                                'type' => 'com',
                                'account_id' => $data['com_account_id'],
                                'transformation' => $id,
                            ]);
                        }
                    // }   
                }
                $oldbelancefrom = Belances::where('id', $oldreportfrom->account_id)->first();
                $oldbelancefrom->belance += (int)$oldreportfrom->amount;
                $oldbelancefrom->save();
                $oldbelanceto = Belances::where('id', $oldreportto->account_id)->first();
                $oldbelanceto->belance -= (int)$oldreportto->amount;
                $oldbelanceto->save();
                // end of old 
                
                $belancefrom = Belances::where('id', $data['from_account_id'])->first();
                $belancefrom->belance -= (int)$data['from_amount'];
                $belancefrom->save();
                // 
                $belanceto = Belances::where('id', $data['to_account_id'])->first();
                $belanceto->belance += (int)$data['to_amount'];
                $belanceto->save();
                // 
                $belancecom = Belances::where('id', $data['com_account_id'])->first();
                $belancecom->belance += (int)$data['from_amount'] - (int)$data['to_amount'];
                $belancecom->save();
                // $report = Report::create([
                    // 'user_id => $data['user_id'],
                    $oldreportfrom->discription =$data['from_description'];
                    $oldreportfrom->amount =(int)$data['from_amount'];
                    $oldreportfrom->date_created = $data['date_creation'];
                    $oldreportfrom->type= 'from';
                    $oldreportfrom->account_id = $data['from_account_id'];
                    // $oldreportfrom->cach=$belancefrom->belance;
                    // $oldbelancefrom->transformation = $report->id;
                // ]);
                // $new = Report::where('id', $report->id)->first();
                $oldreportfrom->save();
                // 
                // $to = Report::create([
                    // $oldbelanceto->user_id = $data['user_id'];
                    $oldreportto->discription = $data['to_description'];
                    $oldreportto->amount =(int)$data['to_amount'];
                    $oldreportto->date_created = $data['date_creation'];
                    $oldreportto->type ='to';
                    $oldreportto->account_id = $data['to_account_id'];
                    // 'transformation' => $report->id,
                    // $oldreportto->cach=$belanceto->belance;
                    $oldreportto->save();
                    return response()->json(['bill'=>['to'=>$oldreportto,'from'=>$oldreportfrom,'com'=>$oldreportcom],'belanceto_report' => new BelanceResource($oldbelanceto), 'belancefrom_report' => new BelanceResource($oldbelancefrom), 'belancecom_report' =>$oldbelancecom ?  new BelanceResource($oldbelancecom): null]);

                // return response()->json(['belancecom_report' => new BelanceResource($belancecom), 'belanceto_report' => new BelanceResource($belanceto), 'belancefrom_report' => new BelanceResource($belancefrom)]);          
            }else{
                $oldreportfrom = Report::where('transformation', $id)->where('type','from')->first();
                $oldreportto = Report::where('transformation', $id)->where('type','to')->first();
                if($old=="ok"){
                $oldreportcom = Report::where('transformation', $id)->where('type','com')->first();
                // if()
                $oldbelancecom = Belances::where('id', $oldreportcom->account_id)->first();
                $oldbelancecom->belance -=(int)$oldreportfrom->amount - (int)$oldreportto->amount;
                $oldbelancecom->save();
                // $oldreportcom->isdelete=1;
                // $oldreportcom->amount = $data['from_amount'] - $data['to_amount'];
                // $oldreportcom->date_created = $data['date_creation'];
                // 'type' => 'com',
                $oldreportcom->isdelete=1;
                $oldreportcom->save();
                // 'transformation' =$report['id']
                // $oldreportcom->cach=$belancecom->belance;
            // ]);
                }
                $oldbelancefrom = Belances::where('id', $oldreportfrom->account_id)->first();
                $oldbelancefrom->belance += (int)$oldreportfrom->amount;
                $oldbelancefrom->save();
                $oldbelanceto = Belances::where('id', $oldreportto->account_id)->first();
                $oldbelanceto->belance -= (int)$oldreportto->amount;
                $oldbelanceto->save();
                // end of old 
                
                $belancefrom = Belances::where('id', $data['from_account_id'])->first();
                $belancefrom->belance -= (int)$data['from_amount'];
                $belancefrom->save();
                // 
                $belanceto = Belances::where('id', $data['to_account_id'])->first();
                $belanceto->belance += (int)$data['to_amount'];
                $belanceto->save();
                // 
                if (isset($data['date_creation'])) {
                    // Convert any format to MySQL datetime format
                    $data['date_creation'] = Carbon::parse($data['date_creation'])->format('Y-m-d H:i:s');
                    $oldreportfrom->date_created = $data['date_creation'];
                }
                // $report = Report::create([
                    // 'user_id => $data['user_id'],
                    $oldreportfrom->discription =$data['from_description'];
                    $oldreportfrom->amount = (int)$data['from_amount'];
                    $oldreportfrom->type= 'from';
                    $oldreportfrom->account_id = $data['from_account_id'];
                    // $oldreportfrom->cach=$belancefrom->belance;
                    // $oldbelancefrom->transformation = $report->id;
                // ]);
                // $new = Report::where('id', $report->id)->first();
                $oldreportfrom->save();
                // 
                // $to = Report::create([
                    // $oldbelanceto->user_id = $data['user_id'];
                    $oldreportto->discription = $data['to_description'];
                    $oldreportto->amount =(int)$data['to_amount'];
                    $oldreportto->date_created = $data['date_creation'];
                    $oldreportto->type ='to';
                    $oldreportto->account_id = $data['to_account_id'];
                    $oldreportto->save();
                    // 'transformation' => $report->id,
                    // $oldreportto->cach=$belanceto->belance;
                   return response()->json(['bill'=>['to'=>$oldreportto,'from'=>$oldreportfrom],'belanceto_report' => new BelanceResource($oldbelanceto), 'belancefrom_report' => new BelanceResource($oldbelancefrom) ]);
            }
        }
    }

    // حذف یک گزارش
    public function destroy($id)
    {
        try {
            $report = Report::find($id);

            if ($report) {
                $report->delete();
                return response()->json(['message' => 'Report deleted successfully'], 200);
            } else {
                return response()->json(['error' => 'Report not found'], 404);
            }
        } catch (Exception $e) {
            return response()->json([
                'error' => 'Failed to delete report'
            ], 500);
        }
    }

    //     public function sumByMoneyType(Request $request)
    // {
    //     // $moneytype = $request->query('moneytype');
    //     // if (!$moneytype) {
    //     //     return response()->json(['error' => 'moneytype parameter is required'], 400);
    //     // }

    //     // $totalAmount = \DB::table('reports')
    //     //     ->where('account_type', $moneytype)
    //     //     ->where('isdelete', false)
    //     //     ->sum('amount');

    //     return response()->json(['total_amount' => "hi"]);
    // }

    public function sumByMoneyType(Request $request)
    {
        // $moneytype = $request->query('moneytype');

        // if (!$moneytype) {
        //     return response()->json(['error' => 'moneytype parameter is required'], 400);
        // }

        // $totalAmount = YourModel::where('account_type', $moneytype)
        //     ->where('isdelete', false)
        //     ->sum('amount'); // Use sum instead of aggregate for direct total calculation

        return response()->json('total_amount');
    }


    public function getLastReportId()
    {
        $lastReport = \DB::table('reports')->latest('id')->first();
        if (!$lastReport) {
            return response()->json(['error' => 'No reports found']);
        }

        return response()->json(['last_report_id' => $lastReport->id]);
    }
    public function checkBalance(Request $request)
    {
        $accountId = $request->query('id');
        if (!$accountId) {
            return response()->json(['error' => 'id parameter is required'], 400);
        }

        $report = \DB::table('reports')->where('account_id', $accountId)->first();

        if ($report) {
            return response()->json(['find' => $report]);
        } else {
            return response()->json(['find' => '']);
        }
    }

    // اعتبارسنجی و دریافت داده‌های درخواست
    protected function getData(Request $request)
    {
        $rules = [
            'user_id' => 'required',
            'from_account_id' => 'required',
            'from_amount' => '',
            'from_description' => '',
            'to_account_id' => 'required',
            'to_amount' => '',
            'to_description' => '',
            'com_account_id' => '',
            'com_amount' => '',
            'com_description' => '',
            'date_creation' => '',
        ];
        $data = $request->validate($rules);
        return $data;
    }
}