<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Resources\BelanceResource;
use App\Http\Resources\MoneyResource;
use App\Models\Item;
use App\Models\Returnsellbills;
use App\Models\Returnsells;
use App\Models\User;
use App\Models\Sell;
use App\Models\Moneys;
use App\Models\Belances;
use App\Models\Report;
use App\Models\Accounts;
use App\Models\Bill;
use Illuminate\Http\Request;
use Exception;
use Carbon\Carbon;

class ReturnSellBillController extends Controller
{

        public function dateChange($date)
            {
                if ($date) {
                    try {
                        return Carbon::parse($date)->format('Y-m-d H:i:s');
                    } catch (\Exception $e) {
                        return response()->json(['error' => 'error'], 422);
                    }
                }
            
                return null; 
                }

    // لیست فروش‌ها
    public function index(Request $request)
    {
        $isDelete = intval($request->query('delete', 0)); // Default to 0 if not provided
        $perPage = intval($request->query('perPage', 10)); // Default 10 items per page
        $currentPage = max(1, intval($request->query('page', 1))); // Default to page 1

        // Fetch and group data directly from the database
        $query = Returnsells::with(['bill.money', 'user', 'bill.accounts.account', 'stock'])
            // ->where('isdelete', $isDelete)
            ->whereHas('bill', function ($query) use ($isDelete) {
                $query->where('isdelete', $isDelete);
            })
            ->orderBy('dateInsert', 'desc');

        // Fetch grouped data
        $groupedData = $query->get()->groupBy('bill.id');

        // Map the grouped data
        $data = $groupedData->map(function ($group) {
            $firstSell = $group->first();
            $bill = $firstSell->bill;

            return [
                'bill' => $bill,
                'money' => $bill->money,
                'sells' => $group->toArray(),
            ];
        });

        // Paginate manually
        $totalGroups = $data->count();
        $paginatedData = $data
            ->slice(($currentPage - 1) * $perPage, $perPage)
            ->values(); // Reset array keys

        // Return response with pagination
        return response()->json([
            'data' => $paginatedData,
            'total' => $totalGroups,
            'current_page' => $currentPage,
            'per_page' => $perPage,
            'last_page' => ceil($totalGroups / $perPage),
        ]);
    }



    // ذخیره فروش جدید
    public function store(Request $request)
    {
        $Exesting = $request->query('Exesting');
        $bill_prev = $request->query('bill_prev');
        $money = $request->query('money');
        $accounts_id = $request->query('accounts_id');
        $PaidAmount = $request->query('PaidAmount');
        $TotalAmount = $request->query('TotalAmount');
        $CustomerName = $request->query('CustomerName');
        $bill_id = $request->query('bill_id');
        $create = null;
        $validatedData = $request->validate([
            'arr' => 'required|array',
            'arr.*.item_id' => '',
            'arr.*.sell' => '',
            'arr.*.bill_id' => '',
            'arr.*.accounts_id' => '',
            'arr.*.qty' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'arr.*.weight' => 'nullable',
            'arr.*.dateInsert' => '',
            'arr.*.rate' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'arr.*.user_id' => 'required',
            'arr.*.isdelete' => 'nullable|boolean',
            'arr.*.purchase_price' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'arr.*.sell_price' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'arr.*.expiry_date' => '',
            'arr.*.description' => 'nullable',
            'arr.*.cobin_id' => 'nullable',
        ]);
        if ($Exesting === 'ok') {
            $bill = 0;
            $product = 0;
            $create = Belances::where('type_id', $money)->where('account_id', $accounts_id)->first();
            if ($create) {
                $create->belance += $TotalAmount - $PaidAmount; // Assuming the quantity field in the stock table // Assuming the quantity field in the stock table
                $create->save();
                // $date = rtrim($validatedData['arr'][0]['dateInsert'], 'Z') . '+00:00';
                $date = $this->dateChange($validatedData['arr'][0]['dateInsert']);

                $product = Belances::where('account_id', 1)
                    ->where('type_id', $money)
                    ->first();
                $product->belance -= $TotalAmount; // Assuming the quantity field in the stock table // Assuming the quantity field in the stock table
                $product->save();
                $bill = Returnsellbills::create([
                    'accounts_id' => $create->id,
                    'user_id' => $validatedData['arr'][0]['user_id'],
                    'total' => $TotalAmount,
                    'PaidAmount' => $PaidAmount,
                    'Remain' => $PaidAmount - $TotalAmount,
                    'dateInsert' => $date,
                    'type' => 'sell',
                    'money_id' => $money,
                    'bill_sell' => $bill_prev
                ]);
                $billSell = Bill::where('id', $bill_id)->first();
                if ($billSell) {
                    $billSell->bill_sell_return = $bill->id;
                    $billSell->save();
                }
                // $reportinbill = Report::where('bill_id', $$bill_prev)->first();
                // $reportinbill->amount+=$TotalAmount - $PaidAmount;
                $reportinbill = Report::create([
                    'isdelete' => 0,
                    'user_id' => $validatedData['arr'][0]['user_id'],
                    'cash',
                    'discription' => 'By ReturnBill Number of ' . strval($bill->id),
                    'amount' => $TotalAmount - $PaidAmount,
                    'date_created' => $date,
                    'type' => 'deposite',
                    'account_id' => $create->id,
                    'cach' => $create->belance,
                    'bill_id' => $bill->id
                ]);
                $money = Moneys::where('id', $money)->first();
                $money->cach -= $PaidAmount;
                $money->save();
                foreach ($validatedData['arr'] as $data) {
                    $this->AddItem($data);
                    $data['bill_id'] = $bill->id;
                    try {
                        if (isset($data['dateInsert'])) {
                            // Remove 'Z' and convert to a format that Carbon can parse
                            // $data['dateInsert'] = rtrim($data['dateInsert'], 'Z') . '+00:00';
                            $data['dateInsert'] = $this->dateChange($validatedData['arr'][0]['dateInsert']);

                        }
                        if (isset($data['expiry_date'])) {
                            // $data['expiry_date'] = rtrim($data['expiry_date'], 'Z') . '+00:00';
                            $data['expiry_date']  = $this->dateChange($data['expiry_date'] );

                        }
                        $report = Returnsells::create($data);
                    } catch (Exception $e) {
                        return response()->json([
                            'error' => 'Failed to create report'
                        ], 500);
                    }
                }
                return response()->json([
                    'message' => 'Report created successfully',
                    'bill' => $bill,
                    'belance' => new BelanceResource($create),
                    'mainbelance' => new BelanceResource($product),
                    'moneys' => new MoneyResource($money)
                ], 201);
            }
            return response()->json([
                'message' => 'Report created successfully',
                'bill' => $bill,
                'belance' => new BelanceResource($create),
                'mainbelance' => new BelanceResource($product),
                'moneys' => new MoneyResource($money)
            ], 201);
        } else {
            $product = Belances::where('account_id', 1)
                ->where('type_id', $money)
                ->first();
            $product->belance -= $TotalAmount; // Assuming the quantity field in the stock table // Assuming the quantity field in the stock table
            $product->save();
            // $date = rtrim($validatedData['arr'][0]['dateInsert'], 'Z') . '+00:00';
            $date = $this->dateChange($validatedData['arr'][0]['dateInsert']);
            $bill = Returnsellbills::create([
                'user_id' => $validatedData['arr'][0]['user_id'],
                'total' => $TotalAmount,
                'PaidAmount' => $TotalAmount,
                'Remain' => $TotalAmount,
                'dateInsert' => $date,
                'type' => 'sell',
                'temp_customer' => $CustomerName,
                'money_id' => $money,
                'bill_sell' => $bill_prev
            ]);
            $sellBill = Bill::where('id', $bill_prev)->first();
            $sellBill->bill_sell_return = $bill->id;
            $sellBill->save();
            $money = Moneys::where('id', $money)->first();
            $money->cach -= $TotalAmount;
            $money->save();

            foreach ($validatedData['arr'] as $data) {
                // $data = $this->getData($row);
                $data['bill_id'] = $bill->id;
                $this->AddItem($data);
                try {
                    if (isset($data['dateInsert'])) {
                        // Remove 'Z' and convert to a format that Carbon can parse
                        // $data['dateInsert'] = rtrim($data['dateInsert'], 'Z') . '+00:00';
                        $data['dateInsert'] = $this->dateChange($data['dateInsert']);
                    }
                    if (isset($data['expiry_date'])) {
                        // Remove 'Z' and convert to a format that Carbon can parse
                        $data['expiry_date'] = $this->dateChange($data['expiry_date']);
                        
                    }
                    $report = Returnsells::create($data);
                    return response()->json([
                        'message' => 'Report created successfully',
                        'bill' => $bill,
                        // 'belance'=>new BelanceResource($create),
                        'mainbelance' => new BelanceResource($product),
                        'moneys' => new MoneyResource($money)
                    ], 201);
                } catch (Exception $e) {
                    return response()->json([
                        'error' => $e
                    ], 500);
                }

            }
            return response()->json([
                'message' => 'Report created successfully',
                'bill' => $bill,
                // 'belance'=>new BelanceResource($create),
                'mainbelance' => new BelanceResource($product),
                'moneys' => new MoneyResource($money)
            ], 201);
        }
    }

    protected function AddItem($data)
    {
        $product = Sell::where('id', $data['sell'])->first();
        $product->qty -= (int) $data['qty']; // Assuming the quantity field in the stock table
        $product->save();
        return $product;
    }
    protected function updateItem($data)
    {
        $product = Sell::where('id', $data['sell'])->first();
        $product->qty -= (int) $data['qty']; // Assuming the quantity field in the stock table
        $product->save();
        return $product;
    }
    protected function DeleteItem($data)
    {
        $product = Sell::where('id', $data['sell'])->first();
        $product->qty += (int) $data['qty']; // Assuming the quantity field in the stock table
        // $product->sell_price = $data['sell_price']; // Assuming the quantity field in the stock table
        $product->save();
    }
    // نمایش جزئیات یک فروش
    public function show($billId)
    {
        // Fetch the sells related to the given bill ID
        $sells = Sell::with(['bill.money', 'user', 'bill.accounts.account', 'stock'])
            ->whereHas('bill', function ($query) use ($billId) {
                $query->where('id', $billId);
            })
            ->orderBy('dateInsert', 'desc')
            ->get();
        // Group sells by bill and map the data
        $groupedData = $sells->groupBy('bill.id')->map(function ($group) {
            $firstSell = $group->first();
            $bill = $firstSell->bill;
            return [
                'bill' => $bill,
                'money' => $bill->money,
                'sells' => $group->toArray(),
            ];
        });
        // If no data is found, return a not found response
        if ($groupedData->isEmpty()) {
            return response()->json(['message' => 'No data found for this bill.'], 404);
        }
        // Return the grouped data
        return response()->json($groupedData->first());
    }
    // ویرایش فروش
    public function update($id, Request $request)
    {
        $Exesting = $request->query('Exesting');
        $bill_prev = $request->query('bill_prev');
        $date = $request->query('DateInsert');
        $money = $request->query('money');
        $accounts_id = $request->query('accounts_id');
        $PaidAmount = $request->query('PaidAmount');
        $TotalAmount = $request->query('TotalAmount');
        $CustomerName = $request->query('CustomerName');
        $bill_id = $request->query('bill_id');
        $create = null;
        $validatedData = $request->validate([
            'arr' => 'nullable|array',
            'arr.*.sell' => '',
            'arr.*.item_id' => '',
            'arr.*.bill_id' => '',
            'arr.*.accounts_id' => '',
            'arr.*.qty' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'arr.*.weight' => 'nullable',
            'arr.*.dateInsert' => '',
            'arr.*.rate' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'arr.*.user_id' => 'required',
            'arr.*.isdelete' => 'nullable|boolean',
            'arr.*.purchase_price' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'arr.*.sell_price' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'arr.*.expiry_date' => '',
            'arr.*.description' => 'nullable',
            'arr.*.cobin_id' => 'nullable',
        ]);
        if ($Exesting === 'ok') {
            $bill = 0;
            $product = 0;
            $create = Belances::where('type_id', $money)->where('account_id', $accounts_id)->first();
            if ($create) {
                $bill = Returnsellbills::where('id', $id)->first();
                $create->belance -= $bill->total - $bill->PaidAmount; // Assuming the quantity field in the stock table // Assuming the quantity field in the stock table
                $create->belance += $TotalAmount - $PaidAmount; // Assuming the quantity field in the stock table // Assuming the quantity field in the stock table
                $create->save();
                $date = rtrim($date, 'Z') . '+00:00';
                $product = Belances::where('account_id', 1)
                    ->where('type_id', $money)
                    ->first();
                $product->belance -= $TotalAmount; // Assuming the quantity field in the stock table // Assuming the quantity field in the stock table
                $product->belance += $bill->total;
                $product->save();
                $billSell = Bill::where('id', $bill_id)->first();
                if ($billSell) {
                    $billSell->bill_sell_return = $bill->id;
                    $billSell->save();
                }
                $reportinbill = Report::where('bill_id', $id)->first();
                $reportinbill->amount = $TotalAmount - $PaidAmount;
                $reportinbill->save();
                $money = Moneys::where('id', $money)->first();
                $money->cach -= $PaidAmount;
                $money->cach += $bill->PaidAmount;
                $money->save();
                $bill->total = $TotalAmount;
                $bill->PaidAmount = $PaidAmount;
                $bill->Remain = $PaidAmount - $TotalAmount;
                $bill->save();
                Returnsells::where('bill_id', $bill->id)->delete();

                // حذف همه رکوردهای قبلی از پایگاه داده
                Returnsells::where('bill_id', $bill->id)->delete();
                foreach ($validatedData['arr'] as $data) {
                    $this->updateItem($data);
                    $data['bill_id'] = $bill->id;
                    try {
                        if (isset($data['dateInsert'])) {
                            // Remove 'Z' and convert to a format that Carbon can parse
                            // $data['dateInsert'] = rtrim($data['dateInsert'], 'Z') . '+00:00';
                            $data['dateInsert'] = $this->dateChange($data['dateInsert']);
                        }
                        if (isset($data['expiry_date'])) {
                            // $data['expiry_date'] = rtrim($data['expiry_date'], 'Z') . '+00:00';
                            $data['expiry_date'] = $this->dateChange($data['expiry_date']);
                        }
                        $report = Returnsells::create($data);
                    } catch (Exception $e) {
                        return response()->json([
                            'error' => 'Failed to create report'
                        ], 500);
                    }
                }
                return response()->json([
                    'message' => 'Report created successfully',
                    'bill' => $bill,
                    'belance' => new BelanceResource($create),
                    'mainbelance' => new BelanceResource($product),
                    'moneys' => new MoneyResource($money)
                ], 201);
            }
            return response()->json([
                'message' => 'Report created successfully',
                'bill' => $bill,
                'belance' => new BelanceResource($create),
                'mainbelance' => new BelanceResource($product),
                'moneys' => new MoneyResource($money)
            ], 201);
        } else {
            $product = Belances::where('account_id', 1)
                ->where('type_id', $money)
                ->first();
            $product->belance -= $TotalAmount; // Assuming the quantity field in the stock table // Assuming the quantity field in the stock table
            $product->save();
            $date = rtrim($date, 'Z') . '+00:00';
            $bill = Returnsellbills::where('id', $id)->first();
            $sellBill = Bill::where('id', $bill->bill_sell)->first();
            $sellBill->bill_sell_return = $bill->id;
            $sellBill->save();
            $money = Moneys::where('id', $money)->first();
            $money->cach += $bill->total;
            $money->cach -= $TotalAmount;
            $money->save();
            $bill->total = $TotalAmount;
            $bill->PaidAmount = $PaidAmount;
            $bill->Remain = $PaidAmount - $TotalAmount;
            $bill->save();
            $lastsell = Returnsells::where('bill_id', $bill->id)->get();
            foreach ($lastsell as $data) {
                $this->DeleteItem($data);
            }
            // حذف همه رکوردهای قبلی از پایگاه داده
            Returnsells::where('bill_id', $bill->id)->delete();
            foreach ($validatedData['arr'] as $data) {
                // $data = $this->getData($row);
                $data['bill_id'] = $bill->id;
                $this->updateItem($data);
                try {
                    if (isset($data['dateInsert'])) {
                        // Remove 'Z' and convert to a format that Carbon can parse
                        // $data['dateInsert'] = rtrim($data['dateInsert'], 'Z') . '+00:00';
                        $data['dateInsert'] = $this->dateChange($data['dateInsert']);
                    }
                    if (isset($data['expiry_date'])) {
                        // Remove 'Z' and convert to a format that Carbon can parse
                        // $data['expiry_date'] = rtrim($data['expiry_date'], 'Z') . '+00:00';
                        $data['expiry_date'] = $this->dateChange($data['expiry_date']);

                    }
                    $report = Returnsells::create($data);
                } catch (Exception $e) {
                    return response()->json([
                        'error' => $e
                    ], 500);
                }
            }
            return response()->json([
                'message' => 'Report created successfully',
                'bill' => $bill,
                // 'belance'=>new BelanceResource($create),
                'mainbelance' => new BelanceResource($product),
                'moneys' => new MoneyResource($money)
            ], 201);
        }
    }
    // حذف فروش
    public function destroy($id)
    {
        try {
            $sell = Sell::findOrFail($id);
            $sell->delete();
            return response()->json(['success' => true, 'message' => 'Sell was successfully deleted.'], 200);
        } catch (Exception $exception) {
            return response()->json(['success' => false, 'message' => 'Error occurred while deleting the sell.'], 500);
        }
    }
    // دریافت داده‌های درخواست
    protected function getData(Request $request)
    {
        $rules = [
            'money' => 'required',
            'item_id' => 'required',
            'accounts_id' => 'required',
            'qty' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'weight' => 'nullable|numeric|min:-9|max:9',
            'dateInsert' => '',
            'rate' => 'required|numeric|min:-2147483648|max:2147483647',
            'user_id' => 'required',
            'isdelete' => 'boolean',
            'purchase_price' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'sell_price' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'expiry_date' => '',
            'description' => 'nullable',
            'arr.*.cobin_id' => 'nullable',

        ];
        $data = $request->validate($rules);
        $data['isdelete'] = $request->has('isdelete');
        return $data;
    }
}
