<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Resources\BelanceResource;
use App\Models\Belance;
use App\Models\Moneys;
use App\Models\User;
use App\Models\Report;
use App\Models\Belances;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Resources\ReportResource;
use App\Http\Resources\MoneyResource;
use Illuminate\Support\Facades\DB;
use Exception;

class ReportsController extends Controller
{
    
    public function dateChange($date)
            {
                if ($date) {
                    try {
                        return Carbon::parse($date)->format('Y-m-d H:i:s');
                    } catch (\Exception $e) {
                        return response()->json(['error' => 'error'], 422);
                    }
                }
            
                return null; 
                }
    
    
    // لیست گزارش‌ها
    public function index(Request $request)
    {
        // دریافت فیلترها
        $Customerid = $request->query('Customerid');
        $startDateStr = $request->query('startDate');
        $endDateStr = $request->query('endDate');
        $isDelete = $request->query('delete');
        $type = $request->query('type');
        $report = $request->query('report' || false);
        $moneyId = $request->query('moneyid');
        $accountId = $request->query('AccountId');
        $perPage = $request->query('perPage', 10); // مقدار پیش‌فرض 10
        $search=$request->query('search');
        $startDate = $request->input('StartDate', false);
        $endDate = $request->input('EndDate', false);
        $user_id = $request->input('user_id', false);
        $unlimite=$request->input('unlimite');
        // آغاز ساخت کوئری
        // $query = Report::query();
        $query = Report::with('user', 'account.type');
        // فیلتر بر اساس تاریخ
        // use Carbon\Carbon;use Carbon\Carbon;
        $flag = false;
        $query->where('isdelete', intval($isDelete));
        

        // در صورت نیاز، نتایج را می‌توانید دریافت کنید و بازگشت دهید
// return response()->json($query->get());

        // فیلتر بر اساس شناسه‌های حساب‌ها (در قالب JSON)
        if ($accountId) {
            // تبدیل رشته دریافتی به آرایه از شناسه‌ها
            $accountIds = [];
            $accountIds = explode(',', $accountId); // تبدیل رشته به آرایه با جداکننده ویرگول
            $accountIds = array_map('intval', $accountIds); // تبدیل تمام مقادیر به نوع عددی (integer)
            if($unlimite=='true'){
                $query->whereIn('account_id', $accountIds);
                $startDate=null;
                if($startDateStr){
                    $startDate = Carbon::parse($startDateStr)->startOfDay(); // شروع روز
                }elseif($endDateStr){
                    $startDate = Carbon::parse($endDateStr)->startOfDay(); // شروع روز
                }
                $results = DB::table('reports')
                    ->select('account_id',
                        DB::raw('SUM(CASE 
                                    WHEN (type = "deposite" OR type = "to" OR type = "com") 
                                        AND date_created <= "' . $startDateStr . '" 
                                    THEN amount 
                                    ELSE 0 
                                END) 
                                - 
                                SUM(CASE 
                                    WHEN type = "withdraw" OR type = "from" 
                                    AND date_created <= "' . $startDateStr . '" 
                                    THEN amount 
                                    ELSE 0 
                                END) AS total')
                    )
                    ->whereIn('account_id', $accountIds)
                    ->orderBy('account_id')
                    ->groupBy('account_id')
                    ->get();
                if ($startDateStr && $endDateStr) {
                    $flag = true;
                    // تبدیل تاریخ‌ها به فرمت صحیح با استفاده از Carbon
                    $startDate = Carbon::parse($startDateStr)->startOfDay(); // شروع روز
                    $endDate = Carbon::parse($endDateStr)->endOfDay(); // پایان روز
                    // اعمال فیلتر در درخواست پایگاه داده
                    $query->whereBetween('date_created', [$startDate, $endDate]);
                } elseif ($startDateStr) {
                    $flag = true;
                    // زمانی که فقط تاریخ شروع وارد می‌شود
                    $startDate = Carbon::parse($startDateStr)->startOfDay(); // شروع روز
                    // اعمال فیلتر با تاریخ شروع
                    $query->where('date_created', '>=', $startDate);
                } elseif ($endDateStr) {
                    $flag = true;
                    // زمانی که فقط تاریخ پایان وارد می‌شود
                    $endDate = Carbon::parse($endDateStr)->endOfDay(); // پایان روز
                    // اعمال فیلتر با تاریخ پایان
                    $query->where('date_created', '<=', $endDate);
                }
                // $query->whereIn('account_id', $accountIds)->orderBy('account_id'); // فیلتر کردن داده‌ها بر اساس شناسه‌ها
                return response()->json(['data' => $query->get(),'total'=>$results]);        
            }
            // اعمال فیلتر بر اساس شناسه‌ها
            $query->whereIn('account_id', $accountIds)->orderBy('account_id')->orderby("date_created"); // فیلتر کردن داده‌ها بر اساس شناسه‌ها
            return response()->json($query->get());
        }
        if ($Customerid) {
            $query->where('account_id', strval($Customerid));
            return response()->json($query->get());
        }
        // دریافت نتایج و بازگشت به صورت JSON
        //         // فیلتر بر اساس نوع
        if ($type !== "all") {
            $query->where('type', strval($type));
        } else {

        }
        // فیلتر بر اساس وضعیت حذف
        // if ($isDelete) {
        // }
        if ($user_id && $user_id != '0') {
            $query->where('user_id', $user_id);
            $query->where('user_id', $user_id);            
        }
        if ($startDate && $endDate) {
            // $query->whereBetween('dateInsert', [$startDate, $endDate]);
            $query->whereBetween('date_created', [$startDate, $endDate]);
        }
        
        if ($startDate) {
            // $query->where('dateInsert', '>=', $startDate);
            $query->where('date_created', '>=', $startDate);
        }
        
        if ($endDate) {
            $query->where('date_created', '<=', $endDate);
            // $query->where('date_created', '<=', $endDate);
        }

        if ($search !== 'false') {
            $query->whereHas('account.account', function ($q) use ($search) { 
                $q->where('name', 'like', "%$search%");
            });
        }
      
        // فیلتر بر اساس شناسه پول
        if ($moneyId) {
            $query->whereHas('account', function ($query) use ($moneyId) {
                $query->where('type_id', $moneyId);
            });
        }
        // اجرای کوئری با صفحه‌بندی
        $query->orderBy('date_created','desc');
        $reports = $query->paginate($perPage);

        // بازگشت داده‌ها همراه با اطلاعات صفحه‌بندی
        return response()->json([
            'data' => ReportResource::collection($reports),  // داده‌ها
            'total' => $reports->total(),  // تعداد کل رکوردها
            'current_page' => $reports->currentPage(),  // صفحه فعلی
            'per_page' => $reports->perPage(),  // تعداد آیتم‌ها در هر صفحه
            'last_page' => $reports->lastPage(),  // آخرین صفحه
        ], 200);
    }

    // ذخیره یک گزارش جدید
    public function store(Request $request)
    {
        $data = $this->getData($request);
        try {
            if (isset($data['date_created'])) {
                // Remove 'Z' and convert to a format that Carbon can parse
                $data['date_created'] = $this->dateChange($data['date_created']);
                // rtrim($data['date_created'], 'Z') . '+00:00';
                
            }
            $report = Report::create($data);

            $belance = Belances::where('id', $report->account_id)->first();
            $money = Moneys::where('id', $belance->type_id)->first();
            if ($data['type'] === 'deposite') {
                $belance->belance += $report->amount;
                $money->cach += $report->amount;
                // $data['cach']=$belance->belance;
            } else {
                $belance->belance -= $report->amount;
                $money->cach -= $report->amount;
                // $data['cach']=$belance->belance;
            }
            $money->ontransaction = 1;
            $belance->ontransaction = 1;
            $money->save();
            $belance->save();

            return response()->json([
                'moneys' => new MoneyResource($money), // اصلاح شده
                'report_belance' => $belance,
                'belance' => new BelanceResource($belance), // اصلاح شده
                'report' => $report->id,
            ], 201);
        } catch (Exception $e) {
            return response()->json([
                'error' => $e
            ], 500);
        }
    }
    // نمایش یک گزارش
    public function show($id)
    {
        $report = Report::with('user', 'account')->find($id);

        if ($report) {
            return response()->json($report, 200);
        } else {
            return response()->json(['error' => 'Report not found'], 404);
        }
    }

    // به‌روزرسانی یک گزارش
    public function update($id, Request $request)
    {
        $type = $request->get('type');
        $data = $this->getData($request);
       if (isset($data['date'])) {
    // Convert any format to MySQL datetime format
    $data['date'] = Carbon::parse($data['date'])->format('Y-m-d H:i:s');
}
if (isset($data['date_created'])) {
    // Convert any format to MySQL datetime format
    $data['date_created'] = Carbon::parse($data['date_created'])->format('Y-m-d H:i:s');
}

        if ($type === 'delete') {
            $report = Report::find($id);
            if ($report) {
                $report->isdelete = 1;
                $belance = Belances::where('id', $report->account_id)->first();
                $money = Moneys::where('id', $belance->type_id)->first();
                if ($report->type === 'deposite') {
                    $belance->belance -= $report->amount;
                    $money->cach -= $report->amount;
                    // $report->cach=$belance->belance;
                } else {
                    $belance->belance += $report->amount;
                    $money->cach += $report->amount;
                    // $report->cach=$belance->belance;
                }
                $money->ontransaction = 1;
                $belance->ontransaction = 1;
                $report->save();
                $money->save();
                $belance->save();

                return response()->json([
                    'moneys' => new MoneyResource($money), // اصلاح شده
                    'report_belance' => $belance,
                    'belance' => new BelanceResource($belance), // اصلاح شده
                    'report' => $report->id,
                ], 201);
            }
        } else if ($type === 'change') {
            $report = Report::where('id', $id)->first();
            if ($report) {
                $belance = Belances::where('id', $report->account_id)->first();
                $money = Moneys::where('id', $belance->type_id)->first();
                $secondbelance = Belances::where('id', $data['account'])->first();
                if ($report->type === 'deposite') {
                    $belance->belance -= $report->amount;
                    $money->cach -= $report->amount;
                    $secondbelance->belance += $data['amount'];
                    $money->cach += $data['amount'];
                } else {
                    $belance->belance += $report->amount;
                    $money->cach += $report->amount;
                    $secondbelance->belance -= $data['amount'];
                    $money->cach -= $data['amount'];
                }
                $report->update([
                    // 'user_id'=>$data['user_id'],
                    'cash' => $secondbelance->belance,
                    'discription' => $data['discription'],
                    'amount' => $data['amount'],
                    'date_created'=>$this->dateChange($data['date']),
                    'type' => $data['type'],
                    'account_id' => $data['account'],
                ]);
                $money->save();
                $belance->save();
                $secondbelance->save();
                return response()->json([
                    'moneys' => new MoneyResource($money), // اصلاح شده
                    'report_belance' => $belance,
                    'secondreport_belance' => $secondbelance,
                    'belance' => new BelanceResource($belance), // اصلاح شده
                    'secondbelance' => new BelanceResource($secondbelance), // اصلاح شده
                    'report' => new ReportResource($report),
                ], 201);
            }
        } elseif($type==='restore'){
            $report = Report::find($id);
            if ($report) {
                $report->isdelete = 0;
                $belance = Belances::where('id', $report->account_id)->first();
                $money = Moneys::where('id', $belance->type_id)->first();
                if ($report->type === 'deposite') {
                    $belance->belance += $report->amount;
                    $money->cach += $report->amount;
                    // $report->cach=$belance->belance;
                } else {
                    $belance->belance -= $report->amount;
                    $money->cach -= $report->amount;
                    // $report->cach=$belance->belance;
                }
                $money->ontransaction = 1;
                $belance->ontransaction = 1;
                $report->save();
                $money->save();
                $belance->save();

                return response()->json([
                    'moneys' => new MoneyResource($money), // اصلاح شده
                    'report_belance' => $belance,
                    'belance' => new BelanceResource($belance), // اصلاح شده
                    'report' => $report->id,
                ], 201);
            }
        } 
        else {
            $report = Report::where('id', $id)->first();
            if ($report) {
                $belance = Belances::where('id', $report->account_id)->first();
                $money = Moneys::where('id', $belance->type_id)->first();
                if ($report->type === 'deposite') {
                    $belance->belance -= $report->amount;
                    $money->cach -= $report->amount;
                    $belance->belance += $data['amount'];
                    $money->cach += $data['amount'];
                } else {
                    $belance->belance += $report->amount;
                    $money->cach += $report->amount;
                    $belance->belance -= $data['amount'];
                    $money->cach -= $data['amount'];
                }
                $report->update([
                    'cash' => $belance->belance,
                    'discription' => $data['discription'],
                    'amount' => $data['amount'],
                    'date_created'=>$this->dateChange($data['date']),
                    'type' => $data['type'],
                    'account_id' => $data['account'],
                ]);
                $money->save();
                $belance->save();
                // $secondbelance->save();
                return response()->json([
                    'moneys' => new MoneyResource($money), // اصلاح شده
                    'report_belance' => $belance,
                    'belance' => new BelanceResource($belance), // اصلاح شده
                    'report' => new ReportResource($report),
                ], 201);
            }
        }

    }

    // حذف یک گزارش
    public function destroy($id)
    {
        try {
            $report = Report::find($id);

            if ($report) {
                $report->delete();
                return response()->json(['message' => 'Report deleted successfully'], 200);
            } else {
                return response()->json(['error' => 'Report not found'], 404);
            }
        } catch (Exception $e) {
            return response()->json([
                'error' => 'Failed to delete report'
            ], 500);
        }
    }

    //     public function sumByMoneyType(Request $request)
    // {
    //     // $moneytype = $request->query('moneytype');
    //     // if (!$moneytype) {
    //     //     return response()->json(['error' => 'moneytype parameter is required'], 400);
    //     // }

    //     // $totalAmount = \DB::table('reports')
    //     //     ->where('account_type', $moneytype)
    //     //     ->where('isdelete', false)
    //     //     ->sum('amount');

    //     return response()->json(['total_amount' => "hi"]);
    // }

    public function sumByMoneyType(Request $request)
    {
        // $moneytype = $request->query('moneytype');

        // if (!$moneytype) {
        //     return response()->json(['error' => 'moneytype parameter is required'], 400);
        // }

        // $totalAmount = YourModel::where('account_type', $moneytype)
        //     ->where('isdelete', false)
        //     ->sum('amount'); // Use sum instead of aggregate for direct total calculation

        return response()->json('total_amount');
    }


    public function getLastReportId()
    {
        $lastReport = \DB::table('reports')->latest('id')->first();
        if (!$lastReport) {
            return response()->json(['error' => 'No reports found']);
        }

        return response()->json(['last_report_id' => $lastReport->id]);
    }
    public function checkBalance(Request $request)
    {
        $accountId = $request->query('id');
        if (!$accountId) {
            return response()->json(['error' => 'id parameter is required'], 400);
        }

        $report = \DB::table('reports')->where('account_id', $accountId)->first();

        if ($report) {
            return response()->json(['find' => $report]);
        } else {
            return response()->json(['find' => '']);
        }
    }

    // اعتبارسنجی و دریافت داده‌های درخواست
    protected function getData(Request $request)
    {
        $rules = [
            'isdelete' => 'nullable|boolean',
            'user_id' => 'nullable|exists:users,id',
            'cash' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'discription' => 'nullable|string|max:255',
            'amount' => 'nullable|numeric|min:-9223372036854775800|max:9223372036854775800',
            'date_created' => 'nullable',
            'date' => 'nullable',
            'type' => 'nullable|string|max:255',
            'account_id' => 'nullable|numeric|min:0',
            'account' => 'nullable|numeric|min:0',
            'whatsup_number' => 'nullable',
            'MainDW.isdelete' => 'nullable|boolean',
            'MainDW.user_id' => 'nullable|exists:users,id',
            'MainDW.cash' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'MainDW.discription' => 'nullable|string|max:255',
            'MainDW.amount' => 'nullable|numeric|min:-9223372036854775800|max:9223372036854775800',
            'MainDW.date_created' => '',
            'MainDW.type' => 'nullable|string|max:255',
            'MainDW.account_id' => 'nullable|numeric|min:0',
        ];

        // 'id'=>$this->id,   
        // 'isdelete'=>$this->isdelete,
        // 'user'=>$this->user_id,
        // 'user_name'=>$this->user->name,
        // 'cash'=>$this->cash,
        // 'discription'=>$this->discription,
        // 'amount'=>$this->amount,
        // 'date_created'=>$this->date_created,
        // 'type'=>$this->type,
        // 'moneyid'=>$this->account->type->id,
        // 'moneyType'=>$this->account->type->name,
        // 'account'=>$this->account_id,
        // 'customer'=>$this->account->account->name,
        $data = $request->validate($rules);
        // $data['isdelete'] = $request->has('isdelete');

        return $data;
    }
}
