<?php
namespace App\Http\Controllers;
use App\Models\Rate;
use App\Models\Exchangetime;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;


class RateController extends Controller
{
    // Get all rates
public function index(Request $request)
{
    // دریافت پارامتر date از query یا پیش‌فرض امروز
    $date = $request->query('date');
    if(isset($date)){
       $date = Carbon::parse($date)->addDays()->format('Y-m-d');
    } else {
        $date = date('Y-m-d');
    }

    // پیدا کردن آخرین تبادله با تاریخ کمتر یا مساوی تاریخ ورودی
    $extime = Exchangetime::whereDate('date','=', $date)
        ->orderBy('date', 'desc')
        ->first();

    if (!$extime) {
        $extime = Exchangetime::whereDate('date','<=', $date)
        ->orderBy('date', 'desc')
        ->first();
        if(!$extime){
            $extime = Exchangetime::whereDate('date','>=', $date)
            ->orderBy('date', 'desc')
            ->first();
        if(!$extime){   
            return response()->json([
                'error' => 'هیچ تبادلی برای این تاریخ یافت نشد.'
            ], 404);
        }
        }
    }

    // پیدا کردن نرخ‌ها بر اساس آخرین تاریخ تبادله
    $rate = Rate::where('date', $extime->id)
        ->orderBy('money_id', 'desc')
        ->get();

    return response()->json($rate);
}




public function store(Request $request)
{
    $validated = $request->validate([
        'date' => 'required|date',
        'rates' => 'required|array|min:1',
        'rates.*.money_id' => 'required|integer|exists:moneys,id',
        'rates.*.from_amount' => 'required|numeric|min:0',
        'rates.*.to_amount' => 'required|numeric|min:0',
        'user_id' => 'required|integer|exists:users,id'
    ]);

    try {
        DB::beginTransaction();

        $formattedDate = Carbon::parse($validated['date'])->format('Y-m-d H:i:s');
        
        // استفاده از firstOrCreate برای جلوگیری از خطای تکراری
        $extime = Exchangetime::firstOrCreate(
            [
                'date' => $formattedDate
            ],
            [
                'user_id' => (int)$validated['user_id'],
                'created_at' => now(),
                'updated_at' => now()
            ]
        );

        // پردازش rates
        foreach ($validated['rates'] as $rate) {
            Rate::updateOrCreate(
                [
                    'date' => $extime->id,
                    'money_id' => $rate['money_id']
                ],
                [
                    'from_amount' => $rate['from_amount'],
                    'to_amount' => $rate['to_amount'] ?? 1
                ]
            );
        }

        DB::commit();

        return response()->json([
            'message' => 'Rates updated successfully',
            'exchange_time_id' => $extime->id
        ], 201);

    } catch (\Exception $e) {
        DB::rollBack();
        
        return response()->json([
            'message' => 'Failed to update rates',
            'error' => $e->getMessage()
        ], 500);
    }
}

    // Get a single rate
    public function show($id)
    {
        return Rate::findOrFail($id);
    }

    // Update a rate
    public function update(Request $request, $id)
    {
        $date = $request->query('date');
        $validated = $request->validate([
            // اعتبارسنجی فیلد date به عنوان یک تاریخ (فرمت "YYYY-MM-DD" از سمت کلاینت تولید می‌شود)
            'date' => '',
            // آرایه rates باید اجباری باشد
            'rates' => '',
            // در هر آیتم از آرایه rates:
            //   - money_id اجباری است، باید عدد صحیح بوده و موجودیت آن در جدول money (ستون id) چک شود
            'rates.*.money_id' => '',
            //   - from_amount اجباری است و باید از نوع عددی باشد (در صورت نیاز می‌توانید قوانین بیشتری مثل min:0 اضافه کنید)
            'rates.*.from_amount' => '',
        'rates.*.to_amount' => '',

        ]);
        $extime=Exchangetime::where('date',$date)->first();
           // برای هر آیتم در آرایه rates یک رکورد جدید ایجاد می‌کنیم
        // $extime=Exchangetime::create([
        //     'date',$validated['date'],
        //     'user_id',$validated['user_id']
        // ]);
           // برای هر آیتم در آرایه rates یک رکورد جدید ایجاد می‌کنیم
        foreach ($validated['rates'] as $row) {
            $find=Rate::where('date',$extime->date)->where('money_id',$row->money_id)->first();
            if($find){
                $find->from_amount=$row->from_amount;
                $find->to_amount=$row->to_amount;
                $find->save();
            }else{
                Rate::create($row);
            }
        }
        
        return response()->json('successfully updated', 201);
    }

    // Delete a rate
    public function destroy($id)
    {
        Rate::destroy($id);
        return response()->json(['message' => 'Rate deleted successfully']);
    }
}
