<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RBACController extends Controller
{
    // گرفتن همه رول‌ها به همراه پرمیشن‌های هر رول
    public function getRolesWithPermissions()
    {
        // فقط فیلد id و name رول + پرمیشن‌های مرتبط (id و name)
        $roles = Role::with('permissions:id,name')->get(['id', 'name']);
        
        return response()->json([
            'success' => true,
            'data' => $roles
        ]);
    }

    // گرفتن فقط تمام پرمیشن‌ها (برای نمایش یا هر کاربرد دیگر)
    public function getAllPermissions()
    {
        $permissions = Permission::all(['id', 'name']);
        return response()->json( $permissions
        );
    }
}