<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Resources\BelanceResource;
use App\Http\Resources\MoneyResource;
use App\Models\Accounts;
use App\Models\Belances;
use App\Models\Bill;
use App\Models\Item;
use App\Models\Purchasebills;
use App\Models\Sidebar;
use App\Models\User;
use App\Models\sellBar;
use App\Models\Report;
use App\Models\Moneys;
use App\Models\Stock;
use Illuminate\Http\Request;
use Exception;
use Carbon\Carbon;


class PurchaseBarController extends Controller
{

public function dateChange($date)
        {
                if ($date) {
                    try {
                        return Carbon::parse($date)->format('Y-m-d H:i:s');
                    } catch (\Exception $e) {
                        return response()->json(['error' => 'error'], 422);
                    }
                }
            
                return null; 
        }

    /**
     * Display a listing of the purchases.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
{
    $isDelete = $request->query('delete');
    $perPage = $request->query('perPage', 10);
    $search = $request->query('search');
    $startDate = $request->input('StartDate', false);
    $endDate = $request->input('EndDate', false);
    $user_id = $request->input('user_id', false);
    
    $query = sellBar::with(['bill.money', 'user', 'bill.accounts.account', 'stock', 'cobin'])
        ->whereHas('bill', function ($query) use ($isDelete) {
            $query->where('isdelete', $isDelete);
        });

    if ($user_id && $user_id != '0') {
        $query->where('user_id', $user_id);
    }
    
    if ($startDate && $endDate) {
        $query->whereBetween('dateInsert', [$startDate, $endDate]);
    }
    
    if ($startDate) {
        $query->where('dateInsert', '>=', $startDate);
    }
    
    if ($endDate) {
        $query->where('dateInsert', '<=', $endDate);
    }

    if ($search !== 'false') {
        $query->whereHas('bill', function ($q) use ($search) { 
            $q->where('temp_customer', 'like', "%$search%")
              ->orWhereHas('accounts.account', function ($b) use ($search) {
                  $b->where('name', 'like', "%$search%");
              });
        });
    }

    $query->orderBy('dateInsert', 'desc');
    
    $reports = $query->get()
        ->groupBy(function ($item) {
            return $item->bill->id;
        })
        ->map(function ($group) {
            // محاسبه جمع مقادیر insell از تمام purchaseهای مربوط به این bill
            $totalInsell = $group->sum(function ($purchase) {
                return $purchase->insell ?? 0; // اگر insell وجود نداشت 0 در نظر گرفته شود
            });

            return [
                'bill' => $group->first()->bill,
                'money' => $group->first()->bill->money,
                'purchase' => $group->toArray(),
                'insell' => $totalInsell, // اضافه کردن جمع insell به نتیجه
            ];
        })
        ->values();

    $currentPage = $request->query('page', 1);
    $paginatedData = $reports->slice(($currentPage - 1) * $perPage, $perPage)->toArray();
    
    return response()->json([
        'data' => $paginatedData,
        'total' => $reports->count(),
        'current_page' => $currentPage,
        'per_page' => $perPage,
        'last_page' => ceil($reports->count() / $perPage),
    ], 200);
}

    /**
     * Store a new purchase in the storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request)
    {
        $Exesting = $request->query('Exesting');
        $money = $request->query('money');
        $accounts_id = $request->query('accounts_id');
        $PaidAmount = $request->query('PaidAmount');
        $TotalAmount = $request->query('TotalAmount');
        $CustomerName = $request->query('CustomerName');
        $DateInsert = $request->query('DateInsert');
        $create = null;
        $purchase_money=$money;
        $validatedData = $request->validate([
            'arr' => 'required|array',
            'arr.*.stocks_id' => '',
            'arr.*.accounts_id' => '',
            'arr.*.qty' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'arr.*.weight' => 'nullable',
            'arr.*.dateInsert' => '',
            'arr.*.rate' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'arr.*.user_id' => 'required',
            'arr.*.isdelete' => 'nullable|boolean',
            'arr.*.purchase_price' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'arr.*.sell_price' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'arr.*.expiry_date' => '',
            'arr.*.description' => 'nullable',
            'arr.*.tepm_customer' => 'nullable',
            'arr.*.money_id' => 'nullable',
            'arr.*.cobin_id' => 'nullable',
            'arr.*.remainqty' => 'nullable',
        ]);
        if (isset($DateInsert)) {
            // $DateInsert = rtrim($DateInsert, 'Z') . '+00:00';
                            $DateInsert = Carbon::parse($DateInsert)->format('Y-m-d H:i:s');
        }
        if ($Exesting === 'ok') {
            $create = Belances::where('type_id', $money)->where('account_id', $accounts_id)->first();
            if ($create) {
                $create->belance += $TotalAmount - $PaidAmount; // Assuming the quantity field in the stock table // Assuming the quantity field in the stock table
                $create->save();
                $date = Carbon::parse($validatedData['arr'][0]['dateInsert'])->format('Y-m-d H:i:s');

                $bill = Purchasebills::create([
                    'accounts_id' => $create->id,
                    'user_id' => $validatedData['arr'][0]['user_id'],
                    'total' => $TotalAmount,
                    'PaidAmount' => $PaidAmount,
                    'Remain' => $PaidAmount - $TotalAmount,
                    'dateInsert' => $date,
                    'type' => 'purchase',
                    'money_id' => $money,
                ]);
                $reportinbill = Report::create([
                    'isdelete' => 0,
                    'user_id' => $validatedData['arr'][0]['user_id'],
                    'cash',
                    'discription' => 'By Bill Number of ' . strval($bill->id),
                    'amount' => $TotalAmount - $PaidAmount,
                    'date_created' => $date,
                    'type' => 'deposite',
                    'account_id' => $create->id,
                    'bill_id'=>$bill->id,
                ]);
                $product = Belances::where('account_id', 1)
                    ->where('type_id', $money)
                    ->first();
                $product->belance -= $TotalAmount; // Assuming the quantity field in the stock table // Assuming the quantity field in the stock table
                $product->save();
                $money = Moneys::where('id', $money)->first();
                $money->cach -= $PaidAmount;
                $money->save();
                
                foreach ($validatedData['arr'] as $data) {
                    $this->AddItem($data);
                    $data['bill_id'] = $bill->id;
                    try {
                        if (isset($data['dateInsert'])) {
                            // Remove 'Z' and convert to a format that Carbon can parse
                            // $data['dateInsert'] = rtrim($data['dateInsert'], 'Z') . '+00:00';
                            $data['dateInsert'] = Carbon::parse($data['dateInsert'])->format('Y-m-d H:i:s');
                        }
                        if (isset($data['expiry_date'])) {
                            // Remove 'Z' and convert to a format that Carbon can parse
                            $data['expiry_date'] = Carbon::parse($data['expiry_date'])->format('Y-m-d H:i:s');
                            
                            // $data['expiry_date'] = rtrim($data['expiry_date'], 'Z') . '+00:00';
                        }
                        $report = sellBar::create($data);
                    } catch (Exception $e) {
                        return response()->json([
                            'error' => $e
                        ], 500);
                    }
                }
                return response()->json([
                    'message' => 'Report created successfully addbelance',
                    'bill' => $bill,
                    'belance' => new BelanceResource($create),
                    'mainbelance' => new BelanceResource($product),
                    'moneys' => new MoneyResource($money)

                ], 201);
            } else {
                $product = Belances::where('account_id', 1)
                    ->where('type_id', $money)
                    ->first();
                $product->belance -= $TotalAmount; // Assuming the quantity field in the stock table // Assuming the quantity field in the stock table
                $product->save();
                $create = Belances::create([
                    'type_id' => $money,
                    'user_id' => $validatedData['arr'][0]['user_id'],
                    'belance' => $TotalAmount - $PaidAmount,
                    'account_id' => $accounts_id,
                ]);
                $date = Carbon::parse($validatedData['arr'][0]['dateInsert'])->format('Y-m-d H:i:s');

                // $date = rtrim($validatedData['arr'][0]['dateInsert'], 'Z') . '+00:00';
                $bill = Purchasebills::create([
                    'accounts_id' => $create->id,
                    'user_id' => $validatedData['arr'][0]['user_id'],
                    'total' => $TotalAmount,
                    'PaidAmount' => $PaidAmount,
                    'Remain' => $PaidAmount - $TotalAmount,
                    'dateInsert' => $date,
                    'type' => 'purchase',
                    'money_id' => $money
                ]);
                $reportinbill = Report::create([
                    'isdelete' => 0,
                    'user_id' => $validatedData['arr'][0]['user_id'],
                    'cash',
                    'discription' => 'By Bill Number of ' . strval($bill->id),
                    'amount' => $TotalAmount - $PaidAmount,
                    'date_created' => $date,
                    'type' => 'deposite',
                    'account_id' => $create->id,
                    'bill_id'=>$bill->id,
                ]);
                $money = Moneys::where('id', $money)->first();
                $money->cach -= $PaidAmount;
                $money->save();
                foreach ($validatedData['arr'] as $data) {
                    $this->AddItem($data);
                    $data['bill_id'] = $bill->id;
                    $data['money_id']=$purchase_money;
                    try {
                        if (isset($data['dateInsert'])) {
                            // Remove 'Z' and convert to a format that Carbon can parse
                            $data['dateInsert'] = Carbon::parse($data['dateInsert'])->format('Y-m-d H:i:s');
                            // $data['dateInsert'] = rtrim($data['dateInsert'], 'Z') . '+00:00';
                        }
                        if (isset($data['expiry_date'])) {
                            // Remove 'Z' and convert to a format that Carbon can parse
                            // $data['expiry_date'] = rtrim($data['expiry_date'], 'Z') . '+00:00';
                            $data['expiry_date'] = Carbon::parse($data['expiry_date'])->format('Y-m-d H:i:s');

                        }
                        $report = sellBar::create($data);
                    } catch (Exception $e) {
                        return response()->json([
                            'error' => $e
                        ], 500);
                    }
                }
                return response()->json([
                    'message' => 'Report created successfully',
                    'bill' => $bill,
                    'belance' => new BelanceResource($create),
                    'mainbelance' => new BelanceResource($product),
                    'moneys' => new MoneyResource($money)

                ], 201);
            }
        } else {
            $product = Belances::where('account_id', 1)
                ->where('type_id', $money)
                ->first();
            $product->belance -= $TotalAmount; // Assuming the quantity field in the stock table // Assuming the quantity field in the stock table
            $product->save();
            // $date = rtrim($validatedData['arr'][0]['dateInsert'], 'Z') . '+00:00';
            $date = Carbon::parse($validatedData['arr'][0]['dateInsert'])->format('Y-m-d H:i:s');

            $bill = Purchasebills::create([
                'id' => 1,
                'temp_cusomter' => $CustomerName,
                'user_id' => $validatedData['arr'][0]['user_id'],
                'total' => $TotalAmount,
                'PaidAmount' => $TotalAmount,
                'Remain' => 0,
                'dateInsert' => $date,
                'type' => 'purchase',
                'money_id' => $money,
                'temp_customer' => $CustomerName
            ]);
            $money = Moneys::where('id', $money)->first();
            $money->cach -= $TotalAmount;
            $money->save();

            foreach ($validatedData['arr'] as $data) {
                // $data = $this->getData($row);
                $data['bill_id'] = $bill->id;
                $this->AddItem($data);
                try {
                    if (isset($data['dateInsert'])) {
                        // Remove 'Z' and convert to a format that Carbon can parse
                        // $data['dateInsert'] = rtrim($data['dateInsert'], 'Z') . '+00:00';
                        $data['dateInsert'] = Carbon::parse($data['dateInsert'])->format('Y-m-d H:i:s');
                    }
                    if (isset($data['expiry_date'])) {
                        // Remove 'Z' and convert to a format that Carbon can parse
                        // $data['expiry_date'] = rtrim($data['expiry_date'], 'Z') . '+00:00';
                        $data['expiry_date'] = Carbon::parse($data['expiry_date'])->format('Y-m-d H:i:s');
                    }
                    $data['money_id']=$purchase_money;
                    $report = sellBar::create($data);
                } catch (Exception $e) {
                    return response()->json([
                        'error' => $e
                    ], 500);
                }
            }
            return response()->json([
                'message' => 'Report created successfully',
                'bill' => $bill,
                'mainbelance' => new BelanceResource($product),
                'moneys' => new MoneyResource($money)

            ], 201);
        }
    }
    protected function AddItem($data)
    {
        $product = Item::where('id', $data['stocks_id'])->first();
        $type=Sidebar::first();
        if($type->type==='gold'){
            $product->weight = bcadd($product->weight, $data['weight'], 3);
        }
        $product->rate = $data['rate']; // Assuming the quantity field in the stock table
        $product->save();
        return $product;
    }
    protected function DeleteItem($data)
    {
        $product = Item::where('id', $data['stocks_id'])->first();
        $type=Sidebar::first();
        if($type->type==='gold'){
            $product->weight = bcsub($product->weight, $data['weight'], 3);
        }
        $product->weight = bcsub($product->weight, $data['weight'], 3);
        $product->save();
    }


    /**
     * Display the specified purchase.
     *
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($billId)
    {
        // Fetch the sells related to the given bill ID
        $sells = sellBar::with(['bill.money', 'user', 'bill.accounts.account', 'stock'])
            ->whereHas('bill', function ($query) use ($billId) {
                $query->where('id', $billId);
            })
            ->orderBy('dateInsert', 'desc')
            ->get();

        // Group sells by bill and map the data
        $groupedData = $sells->groupBy('bill.id')->map(function ($group) {
            $firstSell = $group->first();
            $bill = $firstSell->bill;

            return [
                'bill' => $bill,
                'money' => $bill->money,
                'purchase' => $group->toArray(),
            ];
        });

        // If no data is found, return a not found response
        if ($groupedData->isEmpty()) {
            return response()->json(['message' => 'No data found for this bill.'], 404);
        }

        // Return the grouped data
        return response()->json($groupedData->first());
    }


    public function update($id, Request $request)
    {
        $prevMoneyId = $request->query('prevMoney');
        $type= $request->query('type');
        $Bill_id = $request->query('Bill_id');
        $Exesting = $request->query('Exesting');
        $money = $request->query('money');
        $accounts_id = $request->query('accounts_id');
        $PaidAmount = $request->query('PaidAmount');
        $TotalAmount = $request->query('TotalAmount');
        $CustomerName = $request->query('CustomerName');
        $primaryPaidAmount = $request->query('primaryPaidAmount');
        $Accounts_id = $request->query('Accounts_id');
        $primaryTotalAmount = $request->query('primaryTotalAmount');
        $DateInsert = $request->query('DateInsert');
        $create = null;
        $purchase_money=$money;
        if($type==='delete'){
            $data= $request->validate([
                'money'=> 'nullable|numeric|min:-2147483648|max:2147483647',
                'bill'=> 'nullable|numeric|min:-2147483648|max:2147483647',
                'sell'=>'nullable|numeric|min:-2147483648|max:2147483647',
            ]);
            sellBar::where('bill_id', $data['bill'])->delete();
            // $purchase = sellBar::where('id', $data['sell'])->get();
            // foreach ($purchase as $row) {
            //     $row->isdelete = 1;
            //     $row->save(); // Save each individual row
            // }
            $bill=Purchasebills::where('id',$data['bill'])->first();
            $bill->isdelete=1;
            $money=Moneys::where('id',$data['money'])->first();
            $money->cach+=$bill->PaidAmount;
            $bill->save();
            $money->save();
            $belance=Belances::where('id',$bill->accounts_id)->first();
            if($belance){
                $belance->belance -= $bill->PaidAmount; // Assuming the quantity field in the stock table // Assuming the quantity field in the stock table
                $belance->save();
            }
            $mainBalance = Belances::where('type_id', $money->id)
                    ->Where('account_id', 1)->first();
            $mainBalance->belance += $bill->PaidAmount; // Assuming the quantity field in the stock table // Assuming the quantity field in the stock table
            $mainBalance->save(); //    
            $reportinbill = Report::where('bill_id', $bill->id)->first();
            if($reportinbill){
                $reportinbill->isdelete=1;
                $reportinbill->save();
            }
        }
        else{
        $validatedData = $request->validate([
            'arr' => 'required|array',
            'arr.*.stocks_id' => '',
            'arr.*.bill_id' => '',
            'arr.*.accounts_id' => '',
            'arr.*.qty' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'arr.*.weight' => 'nullable',
            'arr.*.dateInsert' => '',
            'arr.*.rate' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'arr.*.user_id' => 'required',
            'arr.*.isdelete' => 'nullable|boolean',
            'arr.*.purchase_price' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'arr.*.sell_price' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'arr.*.expiry_date' => '',
            'arr.*.description' => 'nullable',
            'arr.*.tepm_customer' => 'nullable',
            'arr.*.money_id' => 'nullable',
            'arr.*.cobin_id' => 'nullable',
            'arr.*.remainqty' => 'nullable',
        ]);
        if (isset($DateInsert)) {
            // $DateInsert = rtrim($DateInsert, 'Z') . '+00:00';
            $$DateInsert  = Carbon::parse($DateInsert )->format('Y-m-d H:i:s');
        }
        if ($Accounts_id) {
            $prveBelance = Belances::where('id', $Accounts_id)->first();
            $prevMainBelance = Belances::where('account_id', 1)
                ->where('type_id', $prveBelance->type_id)
                ->first();
            $prevMainBelance->belance -= $primaryTotalAmount;
            $prevMainBelance->save();
            $prveBelance->belance -= $primaryTotalAmount - $primaryPaidAmount;
            $prveBelance->save();
            $prveMoney = Moneys::where('id', $money)->first();
            $prveMoney->cach -=  $primaryPaidAmount;
            $prveMoney->save();
            $reportinbill = Report::where('bill_id', $Bill_id)->first();
            if ($reportinbill) {
                $reportinbill->delete();
            }
        } else {
            $prevMainBelance = Belances::where('account_id', 1)
                ->where('type_id', $prevMoneyId)
                ->first();
            $prevMainBelance->belance += (int)$primaryTotalAmount;
            $prevMainBelance->save();
            $prveMoney = Moneys::where('id', $prevMoneyId)->first();
            $prveMoney->cach += (int)$primaryTotalAmount;
            $prveMoney->save();
        }
        // $secondcreate = Belances::where('id', $Accounts_id)->first();
        if ($Exesting === 'ok') {
            $create = Belances::where('type_id', $money)->where('account_id', $accounts_id)->first();
            if ($create) {
                $bill = Purchasebills::where('id', $Bill_id)->first();
                $bill->accounts_id = $create->id;
                $bill->user_id = $validatedData['arr'][0]['user_id'];
                // $bill_total = $TotalAmount;
                $bill->temp_customer = null;
                $bill->PaidAmount = $PaidAmount;
                $bill->Remain = $PaidAmount - $TotalAmount;
                $bill->save();
                // $create->belance -= (int)$bill->total - (int)$bill->PaidAmount;
                $create->belance += $TotalAmount - $PaidAmount; // Assuming the quantity field in the stock table // Assuming the quantity field in the stock table
                $create->save();
                // if (isset($DateInsert)) {
                // $date = rtrim($validatedData['arr'][0]['dateInsert'], 'Z') . '+00:00';
                $date = Carbon::parse($validatedData['arr'][0]['dateInsert'])->format('Y-m-d H:i:s');
                $product = Belances::where('account_id', 1)
                    ->where('type_id', $money)
                    ->first();
                $product->belance -= $TotalAmount; // Assuming the quantity field in the stock table // Assuming the quantity field in the stock table
                // $product->belance +=$bill->TotalAmount;
                $product->save();
                $money = Moneys::where('id', $money)->first();
                // $money->cach+=$bill->PaidAmount;
                $money->cach -= $PaidAmount;
                $money->save();
                $reportinbill = Report::where('bill_id', $Bill_id)->first();
                if ($reportinbill) {
                    $reportinbill->amount = $TotalAmount - $PaidAmount;
                    $reportinbill->account_id = $create->id;
                    $reportinbill->save();
                } else {
                    $reportinbill = Report::create([
                        'isdelete' => 0,
                        'user_id' => $validatedData['arr'][0]['user_id'],
                        'discription' => 'By Bill Number of ' . strval($bill->id),
                        'amount' => $TotalAmount - $PaidAmount,
                        'date_created' => $date,
                        'type' => 'deposite',
                        'account_id' => $create->id,
                        'bill_id' => $create->bill_id
                    ]);
                }
                // sellBar::where('bill_id', $Bill_id)->delete();
                foreach ($validatedData['arr'] as $data) {
                    if (!$data['bill_id']) {
                        $this->AddItem($data);
                        $data['bill_id'] = $bill->id;
                        $data['money_id']=$purchase_money;
                        // $TotalAmount+=(int)$data['purchase_price']*(int)$data['qty'];
                        try {
                            if (isset($data['dateInsert'])) {
                                // Remove 'Z' and convert to a format that Carbon can parse
                                // $data['dateInsert'] = rtrim($data['dateInsert'], 'Z') . '+00:00';
                                $data['dateInsert'] = Carbon::parse($data['dateInsert'])->format('Y-m-d H:i:s');

                            }
                            if (isset($data['expiry_date'])) {
                                // Remove 'Z' and convert to a format that Carbon can parse
                                // $data['expiry_date'] = rtrim($data['expiry_date'], 'Z') . '+00:00';
                                $data['expiry_date'] = Carbon::parse($data['expiry_date'])->format('Y-m-d H:i:s');

                            }
                            $report = sellBar::create($data);
                        } catch (Exception $e) {
                            return response()->json([
                                'error' => $e
                            ], 500);
                        }
                    } else {
                        $this->DeleteItem($data);
                    }
                }
                return response()->json([
                    'message' => 'Report created successfully',
                    'bill' => $bill,
                    'belance' => new BelanceResource($create),
                    'mainbelance' => new BelanceResource($product),
                    'moneys' => new MoneyResource($money)
                ], 201);
            } else {
                $create = Belances::create([
                    'type_id' => $money,
                    'user_id' => $validatedData['arr'][0]['user_id'],
                    'belance' => $TotalAmount - $PaidAmount,
                    'account_id' => $accounts_id,
                ]);
                $bill = Purchasebills::where('id', $Bill_id)->first();
                $product = Belances::where('account_id', 1)
                    ->where('type_id', $money)
                    ->first();
                // $product->belance+=$bill->total;
                $product->belance -= $TotalAmount; // Assuming the quantity field in the stock table // Assuming the quantity field in the stock table
                $product->save();
                // $date = rtrim($validatedData['arr'][0]['dateInsert'], 'Z') . '+00:00';
                $date = Carbon::parse($validatedData['arr'][0]['dateInsert'])->format('Y-m-d H:i:s');
                $money = Moneys::where('id', $money)->first();
                $money->cach -= $PaidAmount;
                $money->save();
                $bill->total = $TotalAmount;
                $bill->Remain = $PaidAmount - $TotalAmount;
                $bill->accounts_id = $create->id;
                $bill->temp_customer = null;
                $bill->money_id = $money;
                $bill->save();
                $reportinbill = Report::where('bill_id', $Bill_id)->first();
                if ($reportinbill) {
                    $reportinbill->amount = $TotalAmount - $PaidAmount;
                    $reportinbill->account_id = $create->id;
                    $reportinbill->save();
                } else {
                    $reportinbill = Report::create([
                        'isdelete' => 0,
                        'user_id' => $validatedData['arr'][0]['user_id'],
                        'discription' => 'By Bill Number of ' . strval($bill->id),
                        'amount' => $TotalAmount - $PaidAmount,
                        'date_created' => $date,
                        'type' => 'deposite',
                        'account_id' => $create->id,
                        'bill_id' => $create->bill_id
                    ]);
                }
                // sellBar::where('bill_id', $Bill_id)->delete();
                foreach ($validatedData['arr'] as $data) {
                    // $data = $this->getData($row);
                    if (!$data['bill_id']) {
                        $this->AddItem($data);
                        $data['bill_id'] = $bill->id;
                        $data['money_id']=$purchase_money;
                        // $TotalAmount+=(int)$data['purchase_price']*(int)$data['qty'];
                        try {
                            if (isset($data['dateInsert'])) {
                                // Remove 'Z' and convert to a format that Carbon can parse
                                // $data['dateInsert'] = rtrim($data['dateInsert'], 'Z') . '+00:00';
                                $data['dateInsert'] = Carbon::parse($data['dateInsert'])->format('Y-m-d H:i:s');

                            }
                            if (isset($data['expiry_date'])) {
                                // Remove 'Z' and convert to a format that Carbon can parse
                                $data['expiry_date'] = Carbon::parse($data['expiry_date'])->format('Y-m-d H:i:s');
                                // $data['expiry_date'] = rtrim($data['expiry_date'], 'Z') . '+00:00';
                            }
                            $data['money_id']=$purchase_money;
                            $report = sellBar::create($data);
                            // return response()->json([
                            //     'message' => 'Report created successfully',
                            //     'bill'=>$bill,
                            //     'belance'=>new BelanceResource($create),
                            //     'mainbelance'=>new BelanceResource($product)
                            // ], 201);
                        } catch (Exception $e) {
                            return response()->json([
                                'error' => $e
                            ], 500);
                        }
                    } else {
                        $this->DeleteItem($data);
                    }
                }
                return response()->json([
                    'message' => 'Report created successfully',
                    'bill' => $bill,
                    'belance' => new BelanceResource($create),
                    'mainbelance' => new BelanceResource($product),
                    'moneys' => new MoneyResource($money)

                ], 201);
            }
        } else {
            $bill = Purchasebills::where('id', $Bill_id)->first();
            $product = Belances::where('account_id', 1)
                ->where('type_id', $money)
                ->first();
                // $prevMoney=Moneys::where('id', $bill->money_id)->first();
            // $prevMoney->cach+=$primaryPaidAmount;
            // $prevMoney->save();
            // $product->belance -=$TotalAmount; // Assuming the quantity field in the stock table // Assuming the quantity field in the stock table
            $product->belance -=(int)$TotalAmount; // Assuming the quantity field in the stock table // Assuming the quantity field in the stock table
            $product->save();
            // $mainBelance=Belances::where('account_id', 1)
            // ->where('type_id', $bill->money_id)
            // ->first();
            // $mainBelance->belance+=(int) $primaryTotalAmount;
            // $mainBelance->save();
            // $date = rtrim($validatedData['arr'][0]['dateInsert'], 'Z') . '+00:00';
            $date = Carbon::parse($validatedData['arr'][0]['dateInsert'])->format('Y-m-d H:i:s');
            $bill->money_id = $money;
            $money = Moneys::where('id', $money)->first();
            $money->cach -= $PaidAmount;
            $money->save();
            $bill->total = $TotalAmount;
            $bill->PaidAmount = $PaidAmount;
            $bill->Remain = 0;
            $bill->temp_customer = $CustomerName;
            $bill->accounts_id = null;
            $bill->save();
            foreach ($validatedData['arr'] as $data) {
                if (!$data['bill_id']) {
                    $data['bill_id'] = $bill->id;
                    $data['money_id']=$purchase_money;
                    $this->AddItem($data);
                    try {
                        if (isset($data['dateInsert'])) {
                        //  $data['dateInsert'] = rtrim($data['dateInsert'], 'Z') . '+00:00';
                         $data['dateInsert'] = Carbon::parse($data['dateInsert'])->format('Y-m-d H:i:s');
                        }
                        if (isset($data['expiry_date'])) {
                            // Remove 'Z' and convert to a format that Carbon can parse
                            // $data['expiry_date'] = rtrim($data['expiry_date'], 'Z') . '+00:00';
                            $data['expiry_date'] = Carbon::parse($data['expiry_date'])->format('Y-m-d H:i:s');

                        }
                        $report = sellBar::create($data);
                    } catch (Exception $e) {
                        return response()->json([
                            'error' => 'Failed to create report'
                        ], 500);
                    }
                } else {
                    $this->DeleteItem($data);
                }

            }
            return response()->json([
                'message' => 'Report created successfully tepm',
                'bill' => $bill,
                // 'belance'=>new BelanceResource($create),
                'mainbelance' => new BelanceResource($product),
                'moneys' => new MoneyResource($money)

            ], 201);
        }
    }}

    /**
     * Remove the specified purchase from the storage.
     *
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy($id)
    {
        try {
            $purchase = sellBar::findOrFail($id);
            $purchase->delete();

            return response()->json([
                'message' => 'sellBar successfully deleted.'
            ], 200);
        } catch (Exception $exception) {
            return response()->json([
                'error' => 'Unexpected error occurred while trying to process your request.'
            ], 500);
        }
    }

    /**
     * Get the request's data from the request.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
            'stocks_id' => '',
            'accounts_id' => '',
            'qty' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'weight' => 'nullable',
            'dateInsert' => '',
            'rate' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'user_id' => 'required',
            'isdelete' => 'nullable|boolean',
            'purchase_price' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'sell_price' => 'nullable|numeric|min:-2147483648|max:2147483647',
            'expiry_date' => '',
            'description' => 'nullable',
            'tepm_customer' => 'nullable',
            'money_id' => 'nullable',
            'cobin_id' => 'nullable',
            'remainqty' => 'nullable'
        ];

        $data = $request->validate($rules);

        $data['isdelete'] = $request->has('isdelete');

        return $data;
    }
}
