<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Symfony\Component\HttpFoundation\Response;

class ImportDatabase extends Controller
{
    public function ImportDatabase(Request $request)
    {
        // اعتبارسنجی فایل آپلود شده
        $request->validate([
            'file' => [
                'required',
                'file',
                'mimetypes:text/plain', // فقط فایل‌های متنی مجاز هستند
                function ($attribute, $value, $fail) {
                    // بررسی پسوند فایل
                    if ($value->getClientOriginalExtension() !== 'sql') {
                        $fail('فایل باید دارای پسوند .sql باشد.');
                    }

                    // بررسی محتوای فایل
                    $content = file_get_contents($value->getRealPath());
                    if (!preg_match('/\b(CREATE|INSERT|UPDATE|DELETE|ALTER|DROP)\b/i', $content)) {
                        $fail('فایل باید حاوی دستورات SQL معتبر باشد.');
                    }
                },
            ],
        ]);

        // دریافت فایل آپلود شده
        $uploadedFile = $request->file('file');

        try {
            // خواندن محتوای فایل SQL
            $filePath = $uploadedFile->getRealPath();
            $sql = file_get_contents($filePath);

            // بررسی اینکه فایل خالی نباشد
            if (empty($sql)) {
                return response()->json(['error' => 'فایل SQL خالی است.'], Response::HTTP_BAD_REQUEST);
            }

            // غیرفعال کردن بررسی کلیدهای خارجی موقتاً
            DB::statement('SET FOREIGN_KEY_CHECKS=0;');

            // اجرای دستورات SQL
            DB::unprepared($sql);

            // فعال کردن بررسی کلیدهای خارجی
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');

            return response()->json(['message' => 'دیتابیس با موفقیت ایمپورت شد.'], Response::HTTP_OK);
        } catch (\Exception $e) {
            // فعال کردن بررسی کلیدهای خارجی در صورت خطا
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');

            // لاگ خطا برای بررسی بیشتر
            Log::error('خطا در ایمپورت دیتابیس: ' . $e->getMessage());

            return response()->json(['error' => 'خطا در ایمپورت دیتابیس: ' . $e->getMessage()], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
}