<?php

namespace App\Http\Controllers;

use App\Models\Accounts;
use App\Models\Belances;
use App\Models\Moneys;
use App\Models\Report;
use Illuminate\Http\Request;
use App\Models\Expense;
use App\Models\ExpenseCategory;
use Carbon\Carbon;

class ExpenseController extends Controller
{
    
        public function dateChange($date)
            {
                if ($date) {
                    try {
                        return Carbon::parse($date)->format('Y-m-d H:i:s');
                    } catch (\Exception $e) {
                        return response()->json(['error' => 'error'], 422);
                    }
                }
            
                return null; 
            }
    
    
    public function index(Request $request)
    {
        // Retrieve all expenses with optional filters
        $query = Expense::with(['category', 'money','user']);
        $isdelete = $request->input('isdelete');
        $search=$request->input('search');
        $all=$request->input('all');
        $user_id=$request->input('user_id', false);
        $query->where('isdelete', '=',$isdelete);
        // if ($request->has('search')) {
            if($all==="ok"){
             return response()->json($query->get());
            }
            if ($search !== 'false') {
                $query->whereHas('category', function($q) use ($search) {
                $q->where('name', 'like', '%' . $search . '%');
            });
        }
        if ($request->has('StartDate')) {
            $query->whereDate('date', '>=', $request->input('StartDate'));
        }

        if ($request->has('EndDate')) {
            $query->whereDate('date', '<=', $request->input('EndDate'));
        }
        $query->orderBy('id', 'desc');
        if ($user_id && $user_id != '0') {
            $query->where('user_id', $user_id);
            $query->where('user_id', $user_id);            
        }
        $expenses = $query->paginate(10);

        return response()->json($expenses);
    }
    public function getCat(Request $request)
    {
        // Retrieve all expense categories
        $name=$request->input('name', false);
        if($name){
            $categories = ExpenseCategory::where('name','like',"%$name%")->get();
            return response()->json($categories);
        }
        $categories = ExpenseCategory::all();
        return response()->json($categories);
    }
    
        
    public function postCat(Request $request)
    {
     
        // Validate and create a new expense
        $validatedData = $request->validate([
            'name' => '',
        ]);

        $expense = ExpenseCategory::create($validatedData);
        return response()->json($expense, 201);   
    }
    public function store(Request $request)
    {
        // Validate and create a new expense
        $validatedData = $request->validate([
            'amount' => '',
            'ex_cat' => '',
            'money_id' => '',
            'description' => 'nullable',
            'date' => '',
            'user_id' => '',
            'isdelete' => '',
        ]);
        if (isset($validatedData['date'])) {
            // Remove 'Z' and convert to a format that Carbon can parse
            // $validatedData['date'] = rtrim($validatedData['date'], 'Z') . '+00:00';
            $validatedData['date'] = $this->dateChange($validatedData['date']);
        }
        $Belance=Belances::where('account_id',1)->where('type_id',(int)$validatedData['money_id'])->first();
        $Belance->belance-=(int)$validatedData['amount'];
        $Belance->save();
        $Cash=Moneys::where('id',(int)$validatedData['money_id'])->first();
        $Cash->cach-=(int)$validatedData['amount'];
        $Cash->save();
        $expense = Expense::create($validatedData);
        $expense->load('money','user', 'category');
        return response()->json($expense, 201);
    }
    public function show($id)
    {
        // Retrieve a specific expense
        $expense = Expense::findOrFail($id);
        return response()->json($expense);
    }
    public function update(Request $request, $id)
{
    $delete = $request->input('delete');
    $recover = $request->input('recover');
    $pdelete = $request->input('pdelete');
    
    if ($delete === 'ok') {
        $expense = Expense::findOrFail($id);
        $report = Report::find($expense->report_id); // تغییر
        if ($report) {
            $report->amount = 0;
            $report->save();
        }
        $Cash = Moneys::where('id', $expense->money_id)->first();
        $Cash->cach += (int)$expense->amount;
        $Cash->save();

        $Belance = Belances::where('account_id', 1)->where('type_id', (int)$expense->money_id)->first();
        $Belance->belance += (int)$expense->amount;
        $Belance->save();

        $expense->isdelete = 1;
        $expense->save();

        return response()->json(null, 204);
    }

    if ($pdelete === 'ok') {
        $expense = Expense::findOrFail($id);
        $report = Report::find($expense->report_id); // تغییر
        $expense->delete();
        if ($report) {
            $report->delete();
        }
        return response()->json('ok', 204);
    }

    if ($recover === 'ok') {
        $expense = Expense::findOrFail($id);

        $Cash = Moneys::where('id', $expense->money_id)->first();
        $Cash->cach -= (int)$expense->amount;
        $Cash->save();

        $Belance = Belances::where('account_id', 1)->where('type_id', (int)$expense->money_id)->first();
        $Belance->belance -= (int)$expense->amount;
        $Belance->save();

        $expense->isdelete = 0;
        $expense->save();

        return response()->json(null, 204);
    }

    $validatedData = $request->validate([
        'amount' => 'required|numeric',
        'ex_cat' => 'required|exists:expense_categories,id',
        'money_id' => 'required|exists:moneys,id',
        'description' => 'nullable|string',
        'date' => '',
    ]);

    if (isset($validatedData['date'])) {
        // $validatedData['date'] = rtrim($validatedData['date'], 'Z') . '+00:00';
        $validatedData['date'] = $this->dateChange($validatedData['date']);
    }

    $expense = Expense::findOrFail($id);
    

    $Belance = Belances::where('account_id', 1)->where('type_id', (int)$validatedData['money_id'])->first();
    $Belance->belance += (int)$expense->amount;
    $Belance->belance -= (int)$validatedData['amount'];
    $Belance->save();

    $expense->update($validatedData);

    return response()->json($expense);
}

public function destroy($id)
    {
        // Delete the expense
        $expense = Expense::findOrFail($id);
        $expense->delete();

        return response()->json(null, 204);
    }    
}
