<?php

namespace App\Http\Controllers;

use App\Models\Belances;
use App\Models\Moneys;
use Illuminate\Http\Request;
use App\Models\Exchange;
use Carbon\Carbon;

class ExchangeController extends Controller
{

    public function dateChange($date)
            {
                if ($date) {
                    try {
                        return Carbon::parse($date)->format('Y-m-d H:i:s');
                    } catch (\Exception $e) {
                        return response()->json(['error' => 'error'], 422);
                    }
                }
            
                return null; 
                }

    /**
     * Display a listing of the resource.
     */
public function index(Request $request)
{
    $search = $request->query('query');
    $isdelete = $request->query('isdelete');
    $page = $request->query('page', 1);
    $perPage = $request->query('perPage', 10);
    $searchname = $request->query('search');
    $startDate = $request->input('StartDate');
    $endDate = $request->input('EndDate');
    $user_id = $request->input('user_id');

    // ✅ define query builder first
    $query = Exchange::with(['fromAccount.account', 'toAccount.account', 'fromMoney', 'toMoney', 'user']);

    // ✅ filter isdelete if provided
    if ($isdelete === '1' || $isdelete === '0') {
        $query->where('isdelete', $isdelete);
    }

    // ✅ filter by user id
    if ($user_id && $user_id != '0') {
        $query->where('user_id', $user_id);
    }

    // ✅ FIXED: Proper date filtering
    if ($startDate || $endDate) {
        if ($startDate && $endDate) {
            // Use DATE() function to compare date part only if using datetime field
            $query->whereDate('date', '>=', $startDate. ' 00:00:00')
                  ->whereDate('date', '<=', $endDate. ' 00:00:00');
        } elseif ($startDate) {
            $query->where('date', '>=', $startDate. ' 00:00:00');
        } elseif ($endDate) {
            $query->whereDate('date', '<=', $endDate. ' 00:00:00');
            
        }
    }

    // ✅ search by description or other fields
    if ($searchname && $searchname !== 'false') {
        $query->where(function($q) use ($searchname) {
            $q->where('description', 'like', "%$searchname%")
              ->orWhereHas('fromAccount.account', function($q) use ($searchname) {
                  $q->where('name', 'like', "%$searchname%");
              })
              ->orWhereHas('toAccount.account', function($q) use ($searchname) {
                  $q->where('name', 'like', "%$searchname%");
              });
        });
    }
        // $query->get();
    // ✅ paginate with proper ordering
    $exchanges = $query->orderBy('created_at', 'desc')
                      ->paginate($perPage, ['*'], 'page', $page);

    return response()->json([
        'success' => true,
        'data' => $exchanges
    ], 200);
}


    /**
     * Store a newly created resource in storage.
     */
public function store(Request $request)
{
    $data = $this->getData($request);
    if(isset($data['date'])){
        $data['date'] = $this->dateChange($data['date']);
    }
    if ($data['type'] === 'cash_from_account') {

        // 1️⃣ Deduct from user's account balance
        $fromBelance = Belances::find($data['from_account_id']);
        $fromBelance->belance -= $data['from_amount'];
        $fromBelance->save();

        // 2️⃣ Add to owner's (main) balance in the same currency
        $fromBelanceOwner = Belances::where('type_id', $data['from_money_id'])
            ->where('account_id', 1)
            ->first();
        $fromBelanceOwner->belance += $data['from_amount'];
        $fromBelanceOwner->save();

        // 3️⃣ Deduct from owner's balance in the target currency
        $toBelanceOwner = Belances::where('type_id', $data['to_money_id'])
            ->where('account_id', 1)
            ->first();
        $toBelanceOwner->belance -= $data['to_amount'];
        $toBelanceOwner->save();

        // 4️⃣ Update the actual cash value
        $cash = Moneys::find($data['to_money_id']);
        $cash->cach -= $data['to_amount'];
        $cash->save();

        // 5️⃣ Record the exchange
        $exchange = Exchange::create($data);

        return response()->json([
            'success' => true,
            'message' => 'Exchange created successfully.',
            'data' => $exchange
        ], 201);

    } 
    elseif ($data['type'] === 'account_from_cash') {

        // 1️⃣ Add cash in the source currency
        $fromMoney = Moneys::find($data['from_money_id']);
        $fromMoney->cach += $data['from_amount'];
        $fromMoney->save();

        // 2️⃣ Add to owner's (main) balance in the source currency
        $toBelanceOwner = Belances::where('type_id', $data['from_money_id'])
            ->where('account_id', 1)
            ->first();
        $toBelanceOwner->belance += $data['from_amount'];
        $toBelanceOwner->save();

        // 3️⃣ Deduct from owner's balance in the destination currency
        $fromBelanceOwner = Belances::where('type_id', $data['to_money_id'])
            ->where('account_id', 1)
            ->first();
        $fromBelanceOwner->belance -= $data['to_amount'];   // ✅ Fixed
        $fromBelanceOwner->save();

        // 4️⃣ Add to user's account balance in destination currency
        $toBelance = Belances::find($data['to_account_id']);
        $toBelance->belance += $data['to_amount'];
        $toBelance->save();

        // 5️⃣ Record the exchange
        $exchange = Exchange::create($data);

        return response()->json([
            'success' => true,
            'message' => 'Exchange created successfully.',
            'data' => $exchange
        ], 201);
    }else if($data['type'] === 'account_to_account'){

        // 2️⃣ Add to owner's (main) balance in the source currency
        $toBelanceOwner = Belances::where('type_id', $data['from_money_id'])
            ->where('account_id', 1)
            ->first();
        $toBelanceOwner->belance += $data['from_amount'];
        $toBelanceOwner->save();

        // 3️⃣ Deduct from owner's balance in the destination currency
        $fromBelanceOwner = Belances::where('type_id', $data['to_money_id'])
            ->where('account_id', 1)
            ->first();
        $fromBelanceOwner->belance -= $data['to_amount'];   // ✅ Fixed
        $fromBelanceOwner->save();

        // 4️⃣ Add to user's account balance in destination currency
        $toBelance = Belances::find($data['to_account_id']);
        $toBelance->belance += $data['to_amount'];
        $toBelance->save();


        $toBelance = Belances::find($data['from_account_id']);
        $toBelance->belance -= $data['from_amount'];
        $toBelance->save();


        // 5️⃣ Record the exchange
        $exchange = Exchange::create($data);

        return response()->json([
            'success' => true,
            'message' => 'Exchange created successfully.',
            'data' => $exchange
        ], 201);
    }
}


    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $exchange = Exchange::with(['fromAccount', 'toAccount', 'from_money', 'to_money', 'user'])->findOrFail($id);

        return response()->json([
            'success' => true,
            'data' => $exchange
        ], 200);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $exchange = Exchange::findOrFail($id);
        $data = $this->getData($request);

        $exchange->update($data);

        return response()->json([
            'success' => true,
            'message' => 'Exchange updated successfully.',
            'data' => $exchange
        ], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $exchange = Exchange::findOrFail($id);
        $exchange->delete();

        return response()->json([
            'success' => true,
            'message' => 'Exchange deleted successfully.'
        ], 200);
    }

    /**
     * Validate and return the request data.
     */
    protected function getData(Request $request)
    {
        return $request->validate([
            'from_account_id' => '',
            'to_account_id' => '',
            'com_account_id' => '',
            'description' => '',
            'rate' => '',
            'rate_type' => '',
            'type' => '',
            'date' => '',
            'from_money_id' => '',
            'to_money_id' => '',
            'from_amount' => '',
            'to_amount' => '',
            'com_amount' => '',
            'user_id' => '',
            'isdelete' => ''
        ]);
    }
}
