<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\cabinet;
use App\Models\CabinStock;
use App\Models\Exchangetime;
use App\Models\Purchase;
use App\Models\Rate;
use App\Models\Returnsells;
use Illuminate\Http\Request;

class CabinetController extends Controller
{
    // لیست همه کابینت‌ها
    public function index()
    {
        return response()->json(cabinet::all());
    }

//  public function getItemsByCabinet(Request $request, $id)
// {
//     $moneyId = $request->query('money_id', 1); // Default to 1 if not passed
//     // Get exchange rate for today or earlier
//     $exchangeTime = Exchangetime::where('date', '<=', now()->format('Y-m-d'))
//                                  ->orderBy('date', 'desc')
//                                  ->first();
//     $exchangeRates = collect();
//     if ($exchangeTime) {
//         $exchangeRates = Rate::where('date', $exchangeTime->id)->get();
//     }
//     $purchaseItems = Purchase::with('cobin')
//     ->where('remainqty', '>', 0)
//     ->where('stocks_id', $id)
//     ->orderBy('cobin_id', 'desc')
//     ->get()
//     ->map(function ($item) use ($moneyId, $exchangeRates) {
//         $item->source = 'purchase';
//         return $this->convertPrice($item, $moneyId, $exchangeRates);
//     });

// $returnItems = Returnsells::with('cobin') // فرض بر اینکه رابطه cobin وجود دارد
//     ->where('item_id', $id)
//     ->orderBy('cobin_id', 'desc')
//     ->get()
//     ->map(function ($item) use ($moneyId, $exchangeRates) {
//         $item->source = 'return_sell';
//         return $this->convertPrice($item, $moneyId, $exchangeRates);
//     });

// // ادغام دو مجموعه
// $items = $purchaseItems->merge($returnItems)->sortByDesc('cobin_id')->values();
    // return response()->json([
    //     'data' => $items,
    //     'exchange' => $exchangeRates,
    // ]);
// }




public function getItemsByCabinet(Request $request, $id){
    
$query = CabinStock::where('item_id', $id)->where('qty','>',0)
    ->with('cobin','money')
    ->get();
    $sum = CabinStock::where('item_id', $id)->sum('qty');

    return response()->json([
        'data' => $query,
        'exchange' => [],
        'total'=>$sum,
    ]);
}


    // ساخت کابینت جدید
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'location' => 'nullable|string|max:255',
            'description' => 'nullable|string',
        ]);

        $cabinet = cabinet::create($validated);

        return response()->json($cabinet, 201);
    }
    protected function convertPrice($item, $moneyId, $exchangeRates)
{
    if ($exchangeRates->isNotEmpty()) {
        // Convert to local currency (1) if needed
        if ($moneyId == 1 && $item->money_id != 1) {
            $rate = $exchangeRates->firstWhere('money_id', $item->money_id);
            if ($rate) {
                $item->purchase_price *= $rate->from_amount;
            }
        }
        // Convert from local to foreign
        elseif ($moneyId != 1 && $item->money_id == 1) {
            $rate = $exchangeRates->firstWhere('money_id', $moneyId);
            if ($rate && $rate->from_amount != 0) {
                $item->purchase_price /= $rate->from_amount;
            }
        }
    }
    return $item;
}


    // نمایش یک کابینت خاص
    public function show($id)
    {
        $cabinet = cabinet::findOrFail($id);
        return response()->json($cabinet);
    }

    // آپدیت یک کابینت
    public function update(Request $request, $id)
    {
        $cabinet = cabinet::findOrFail($id);

        $validated = $request->validate([
            'name' => 'sometimes|required|string|max:255',
            'location' => 'nullable|string|max:255',
            'description' => 'nullable|string',
        ]);

        $cabinet->update($validated);

        return response()->json($cabinet);
    }

    // حذف کابینت
    public function destroy($id)
    {
        $cabinet = cabinet::findOrFail($id);
        $cabinet->delete();

        return response()->json(['message' => 'Cabinet deleted successfully']);
    }
}