<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Resources\AccountsResource;
use App\Models\Accounts;
use App\Models\Bill;
use App\Models\gold_rate;
use App\Models\gold_rate_time;
use App\Models\Item;
use App\Models\Moneys;
use App\Models\Purchase;
use App\Models\Report;
use App\Models\Exchangetime;
use App\Models\Rate;
use App\Models\Sell;
use App\Models\Sidebar;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Carbon\Carbon;

class BenefitController extends Controller
{
  


public function index(Request $request)
{
    // Pagination
    $page = $request->input('page', 1);
    $perPage = $request->input('perPage', 10);

    // فیلترها
    $startDate = $request->input('StartDate');
    $endDate = $request->input('EndDate');
    $user_id = $request->input('user_id');

    // وضعیت طلا
    $sidebars = Sidebar::first()?->type === 'gold';

    // تاریخ شروع و پایان
    $start = $startDate ? Carbon::parse($startDate) : Carbon::now()->subDays(7)->startOfDay();
    $end = $endDate ? Carbon::parse($endDate) : Carbon::now()->endOfDay();

    // واکشی فروش‌ها
    $sellQuery = Sell::with(['bill.money', 'bill', 'stock'])->orderBy('dateInsert', 'asc');
    if ($user_id && $user_id != '0') {
        $sellQuery->where('user_id', $user_id);
    }
    $sellQuery->whereBetween('dateInsert', [$start, $end]);
    $allSales = $sellQuery->get();

    $profitData = [];

    foreach ($allSales as $sell) {
        $sellDate = Carbon::parse($sell->dateInsert)->format('Y-m-d');
        $stockId = $sell->item_id;
        $qty = $sell->qty;
        $purchasePrice = $sell->purchase_price;
        $extime = Exchangetime::whereDate('date', '<=', $sell->dateInsert)
           ->orderBy('date', 'desc')
           ->first();
        $rate = Rate::where('date', $extime->id)->get();

        // محاسبه فروش
        if ($sell->money_id == 1) {
            $sellPrice = $sell->sell_price;
        } else {
            $find = $rate->firstWhere('money_id', $sell->money_id);
            if ($find && $find->from_amount && $find->to_amount) {
                $sellPrice = $sell->sell_price * $find->from_amount / $find->to_amount;
            } else {
                // fallback اگر نرخ پیدا نشد یا مقدار null بود
                $sellPrice = $sell->sell_price; 
            }
        }

        // محاسبه خرید
        if ($sell->money_id_purchase == 1) {
            $purchasePrice = $sell->sell_price;
        } else {
            $find = $rate->firstWhere('money_id', $sell->money_id_purchase);
            if ($find && $find->from_amount && $find->to_amount) {
                $purchasePrice = $sell->purchase_price * $find->from_amount / $find->to_amount;
            } else {
                // fallback
                $purchasePrice = $sell->purchase_price;
            }
        }

        $moneyType = $sell->bill->money->name ?? 'Unknown';
        $WeigthRate = 1;
        $WeigthRateSell = 1;

        if ($sidebars) {
            $goldTimeSell = gold_rate_time::where('date', '<=', $sellDate)->first();
            if ($goldTimeSell) {
                $SellRate = gold_rate::where('date', $goldTimeSell->id)->where('item_type', $sell->stock->type_id)->first();
                if ($SellRate) {
                    $WeigthRateSell = $SellRate->value;
                    $WeigthRate = $SellRate->value;
                }
            }
        }

        $profit = ($sellPrice * $WeigthRateSell - $purchasePrice * $WeigthRate) * $qty;

        if (!isset($profitData[$sellDate][$moneyType])) {
            $profitData[$sellDate][$moneyType] = [
                'total' => 0,
                'details' => []
            ];
        }

        $profitData[$sellDate][$moneyType]['total'] += $profit;
        $profitData[$sellDate][$moneyType]['details'][] = [
            'source' => 'Sell',
            'profit' => $profit,
            'bill_id' => $sell->bill_id,
            'item_id' => $stockId
        ];
    }

    // پردازش گزارش‌ها (Reports)
    $reportQuery = Report::with('account.account')
        ->whereHas('account.account', function ($q) {
            $q->where('id', 1);
        })
        ->where('type', 'com');

    if ($user_id && $user_id != '0') {
        $reportQuery->where('user_id', $user_id);
    }

    $reports = $reportQuery->whereBetween('date_created', [$start, $end])->get();

    foreach ($reports as $report) {
        $reportDate = Carbon::parse($report->date_created)->format('Y-m-d');
        $moneyType = $report->account->type->name ?? 'Unknown';
        $amount = $report->amount;

        if (!isset($profitData[$reportDate][$moneyType])) {
            $profitData[$reportDate][$moneyType] = [
                'total' => 0,
                'details' => []
            ];
        }

        $profitData[$reportDate][$moneyType]['total'] += $amount;
        $profitData[$reportDate][$moneyType]['details'][] = [
            'source' => 'Report',
            'profit' => $amount,
            'report_id' => $report->id
        ];
    }

    // ساخت خروجی نهایی (فقط روزهایی که داده دارند)
    $finalResults = [];

    foreach ($profitData as $date => $currencies) {
        foreach ($currencies as $currency => $data) {
            $finalResults[] = [
                'date' => $date,
                'profit' => $data['total'],
                'currency' => $currency,
                'details' => $data['details']
            ];
        }
    }

    // Pagination
    $total = count($finalResults);
    $offset = ($page - 1) * $perPage;
    $paginatedResults = array_slice($finalResults, $offset, $perPage);

    return response()->json([
        'report' => null,
        'data' => $paginatedResults,
        'total' => $total,
        'page' => $page,
        'perPage' => $perPage,
        'lastPage' => ceil($total / $perPage)
    ]);
}

    public function store(Request $request)
    {
        $data = $this->getData($request);
    
        // ذخیره‌سازی فایل‌های آپلود شده و ایجاد آدرس کامل
        if ($request->hasFile('profile_picture')) {
            // دریافت فایل
            $file = $request->file('profile_picture');
            
            // تعیین نام فایل (می‌توانید نام فایل را تغییر دهید)
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            
            // ذخیره فایل در پوشه public/profile_pictures
            $file->move(public_path('profile_pictures'), $fileName);
            
            // ساخت آدرس کامل برای فایل
            $data['profile_picture'] = asset('profile_pictures/' . $fileName);
        }
    
        if ($request->hasFile('national_id_picture')) {
            // دریافت فایل
            $file = $request->file('national_id_picture');
            
            // تعیین نام فایل (می‌توانید نام فایل را تغییر دهید)
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            
            // ذخیره فایل در پوشه public/national_id_pictures
            $file->move(public_path('national_id_pictures'), $fileName);
            
            // ساخت آدرس کامل برای فایل
            $data['national_id_picture'] = asset('national_id_pictures/' . $fileName);
        }
    
        // ذخیره داده‌ها در دیتابیس
        $account = Accounts::create($data);
        $account=$account->with('user');
        $accountId = $account->id;
    
        return response()->json([
            'id' => $accountId,
            'customer'=>$account,
            'message' => 'Account created successfully.'
        ], 201);
    }
    

    public function show($id)
    {
        $account = Accounts::with('user')->findOrFail($id);
       
        return response()->json($account);
    }
    
    public function update($id, Request $request)
    {
        // بررسی اینکه آیا فایل ارسال شده است
        $data = $this->getData($request);

        if ($request->hasFile('profile_picture')) {
            $request->validate([
                'profile_picture' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                 // محدودیت‌هایی برای فایل
                ]);

            $file = $request->file('profile_picture');
            
            // تعیین نام فایل (می‌توانید نام فایل را تغییر دهید)
            $fileName = time() . '.' . $file->getClientOriginalExtension();
            
            // ذخیره فایل در پوشه public/profile_pictures
            $file->move(public_path('profile_pictures'), $fileName);
            
            // ساخت آدرس کامل برای فایل
            $data['profile_picture'] = asset('profile_pictures/' . $fileName);

            
            // $newImage = $request->file('profile_picture');
            // اعتبارسنجی فایل
                // $data['profile_picture'] =asset('storage/' .  $newImage->store('profile_pictures', 'public'));
        }

        if ($request->hasFile('national_id_picture')) {
            
            // $newImage = $request->file('national_id_picture');
            // اعتبارسنجی فایل
            $request->validate([
                'national_id_picture' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                 // محدودیت‌هایی برای فایل
                ]);
                $file = $request->file('national_id_picture');
            
                // تعیین نام فایل (می‌توانید نام فایل را تغییر دهید)
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                
                // ذخیره فایل در پوشه public/national_id_pictures
                $file->move(public_path('national_id_pictures'), $fileName);
                
                // ساخت آدرس کامل برای فایل
                $data['national_id_picture'] = asset('national_id_pictures/' . $fileName);
            
                // $data['national_id_picture'] =asset('storage/' .  $newImage->store('national_id_pictures', 'public'));
        }
        // فایل ارسال شده را دریافت کنید
    
        // ادامه کار ذخیره فایل در مسیر مشخص
        $settings = Accounts::findOrFail($id);
        $settings->update($data);
        $settings->load('user'); // Use load to eager load the 'user' relationship
        
        return response()->json(['customer' => $settings]);
    }

    public function destroy($id)
    {
        $account = Accounts::findOrFail($id);
        $account->delete();

        return response()->json([
            'message' => 'Account deleted successfully.'
        ]);
    }

   
    protected function getData(Request $request)
    {
        $rules = [
            'ontransaction' => 'boolean',
            'isdelete' => 'boolean',
            'user_id' => 'nullable|exists:users,id',
            'name' => 'nullable|string|min:1|max:255',
            'date_created' => 'nullable|date_format:Y-m-d',
            'father_name' => 'nullable|string|max:255',
            'national_id_number' => 'nullable|string',
            'phone_number' => 'nullable|string',
            'whatsup_number' => 'nullable|string',
            'address' => 'nullable|string|max:255',
            'profile_picture' => 'nullable|max:500000000000000000048', // محدودیت فرمت و سایز
            'national_id_picture' => 'nullable|max:5000000000000000000048', // محدودیت فرمت و سایز
            'whatsup' => 'nullable', // محدودیت فرمت و سایز
        ];

        return $request->validate($rules);
    }
}
