<?php

namespace App\Http\Controllers;
use App\Http\Controllers\Controller;
use App\Models\Accounts;
use App\Models\Moneys;
use App\Models\User;
use App\Models\Belances;
// use App\Models\User;
use App\Http\Resources\BelanceResource;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Log;

use App\Exports\BelancesExport;
use Maatwebsite\Excel\Facades\Excel;
class BelancesController extends Controller
{




// public function exportExcel(Request $request)
// {
//     try {
//         $filters = $request->only(['user_id', 'start_date', 'end_date']);

//         // Validate the input (optional but recommended)
//         $request->validate([
//             'user_id' => 'nullable',
//             'start_date' => 'nullable|date',
//             'end_date' => 'nullable|date',
//         ]);

//         return Excel::download(new BelancesExport($filters), 'belances.xlsx');

//     } catch (\Illuminate\Validation\ValidationException $e) {
//         // Handle validation errors
//         return response()->json([
//             'status' => 'error',
//             'message' => 'Validation failed',
//             'errors' => $e->errors(),
//         ], 422);

//     } catch (\Exception $e) {
//         // Log the error for debugging
//         Log::error('Excel export failed: '.$e->getMessage(), [
//             'stack' => $e->getTraceAsString()
//         ]);

//         return response()->json([
//             'status' => 'error',
//             'message' => 'Failed to export Excel. Please try again later.'
//         ], 500);
//     }
// }




public function exportExcel(Request $request)
{
    $filters = $request->only(['user_id', 'start_date', 'end_date','type']);
    // $filters['type'] = 'debit';

    try {
        $export = new BelancesExport($filters);
        return $export->export('belances.xlsx');
    } catch (\Exception $e) {
        \Log::error('Excel export failed: '.$e->getMessage());
        return back()->with('error', 'Export failed. Please try again.');
    }
}

    
        public function dateChange($date)
        {
                if ($date) {
                    try {
                        return Carbon::parse($date)->format('Y-m-d H:i:s');
                    } catch (\Exception $e) {
                        return response()->json(['error' => 'error'], 422);
                    }
                }
            
                return null; 
        }
    
    
    /**
     * Display a listing of the belances.
     *
     * @return \Illuminate\Http\JsonResponse
     */
     function normalizePersianText($text) {
    $text = str_replace("\xE2\x80\x8C", ' ', $text); // نیم‌فاصله به فاصله
    $text = str_replace(['ي', 'ئ'], 'ی', $text);
    $text = str_replace('ك', 'ک', $text);
    $text = preg_replace('/\s+/', ' ', $text);
    return trim($text);
}

public function index(Request $request)
{
    $type = $request->query('type');
    $search = $request->query('query');
    $isdelete=$request->query('isdelete');
    $do=$request->query('do');
    $moneyid = $request->query('money_id');
    $customerid = $request->query('CustomerId', false);
    $page = $request->query('page', 1); 
    $perPage = $request->query('perPage', 10); 
    $searchname=$request->query('search');
    $startDate = $request->input('StartDate', false);
    $endDate = $request->input('EndDate', false);
    $user_id = $request->input('user_id', false);

    $query = Belances::with('User');
    if ($do==='ok') {
        $query->where('isdelete','0');
        $searchname = trim($searchname);
        // $search= normalizePersianText($search);
        $query->whereHas('account', function ($q) use ($search) {
            $q->where('name', 'like', "%$search%");
            // $q->whereRaw("SUBSTRING_INDEX(name, ' ', 1) LIKE ?", ["{$search}%"]);
        });
        

        // if ($moneyid!=null || $moneyid!=false) {
        //     $query->where('money_id', $moneyid);
        // }
        return response()->json(
            BelanceResource::collection($query->get()));    
    }
    if($customerid){
        $query->where('account_id',  "$customerid");
        return response()->json(
            BelanceResource::collection($query->get()));  
    }
    // اعمال فیلترهای دیگر
    if ($moneyid) {
        $query->where('money_id', $moneyid);
    }
    if ($isdelete==='1'||$isdelete==='0') {
        $query->where('isdelete', $isdelete);
    }
     if ($user_id && $user_id != '0') {
            $query->where('user_id', $user_id);
        }
        if ($startDate && $endDate) {
            // $query->whereBetween('dateInsert', [$startDate, $endDate]);
            $query->whereBetween('date_created', [$startDate, $endDate]);
        }
        
        if ($startDate) {
            // $query->where('dateInsert', '>=', $startDate);
            $query->where('date_created', '>=', $startDate);
        }
        
        if ($endDate) {
            $query->where('date_created', '<=', $endDate);
            // $query->where('date_created', '<=', $endDate);
        }
        $sum=0;
        if($type == 'credit'){
            // $query->where('ontransaction', 1);
            $query->where('belance', '>',0);
            $query->where('account_id', '!=',1);
            $query->orderBy('belance','desc');          
            $sum=$query->sum('belance');
        }

            if($type == 'debit'){
                $query->where('account_id', '!=', 1)
                    ->where('belance', '<', 0);
            $query->orderBy('belance','desc');            

            }

            // گرفتن همه رکوردها
            $belances = $query->get();

            // گروه‌بندی بر اساس money_id
                            // گروه‌بندی بر اساس money_id
                $grouped = $belances->groupBy('type_id');

                $result = [];

                foreach ($grouped as $type_id => $items) {
                    // بررسی وجود relation type و نام ارز
                    $currencyName = 'Unknown';
                    
                    if ($items->isNotEmpty() && $firstItem = $items->first()) {
                        $currencyName = $firstItem->type->name ?? 'Unknown';
                    }

                    $result[] = [
                        'name' => $currencyName,
                        'amount' => $items->sum('belance'),
                        'qty' => $items->count(),
                        'money_id' => $type_id // اضافه کردن ID برای شناسایی بهتر
                    ];
                }

                // اگر می‌خواهید بر اساس amount مرتب شود:
                $result = collect($result)->sortByDesc('amount')->values()->all();



        if ($searchname !== 'false') {
            $query->whereHas('account', function ($q) use ($searchname) { 
                $q->where('name', 'like', "%$searchname%");
            });
        }
    $query->orderBy('id', 'desc');
    $belances = $query->paginate($perPage, ['*'], 'page', $page);
    return response()->json([
        'data' => BelanceResource::collection($belances),
        'total' => $belances->total(),
        'totalCureencies'=>$result
    ]);
}
public function getcomesion(Request $request){

    $search = $request->query('money');
    $query = Belances::where('account_id', 1)->where('type_id',(int)$search);
    return response()->json(
        BelanceResource::collection($query->get())
    );  
    
}

    /**
     * Show the form for creating a new belance (not needed in API).
     */

    /**`
     * Store a new belance in the storage.
     *
     * @param Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request)
    {
        $data = $this->getData($request);
        if (isset($data['date_created'])) {
            // Remove 'Z' and convert to a format that Carbon can parse
            // $data['date_created'] = rtrim($data['date_created'], 'Z') . '+00:00';
            $data['date_created'] = $this->dateChange($data['date_created']);
        }
        $customer=Accounts::where('id',$data['account_id'])->first();
        if(!$customer==null){
        $customer->ontransaction=1;
        }
        $customer->save();
        $belance = Belances::create($data);
        return response()->json([
            'message' => 'Belance created successfully.',
            'belance' => new BelanceResource($belance) ,
        ], 201);
    }


    /**
     * Update the specified belance in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function update($id, Request $request)
    {
        $data = $this->getData($request);
        if (isset($data['date_created'])) {
            // Remove 'Z' and convert to a format that Carbon can parse
            $data['date_created'] = $this->dateChange($data['date_created']);
        }

        $belance = Belances::findOrFail($id);
        $belance->update($data);

        return response()->json(new BelanceResource($belance));
    }

    /**
     * Remove the specified belance from the storage.
     *
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy($id)
    {
        try {
            $belance = Belances::findOrFail($id);
            $belance->delete();

            return response()->json([
                'message' => 'Belance deleted successfully.'
            ]);
        } catch (Exception $exception) {
            return response()->json([
                'error' => 'Unexpected error occurred while trying to process your request.'
            ], 500);
        }
    }

    public function show($id)
    {
        $balance = Belances::findOrFail($id); // پیدا کردن موجودیت بر اساس ID
        $balanceResource = new BelanceResource($balance); // استفاده از BelanceResource برای موجودیت

        return response()->json($balanceResource); // ارسال پاسخ JSON
    }




    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request $request
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
            'amount_limit'=>'',
            'ontransaction' => 'boolean',
            'user_id' => '',
            'isdelete' => 'boolean',
            'account_id' => 'nullable|numeric|min:0',
            'type_id' => 'nullable|numeric|min:0',
            'belance' => '',
            'date_created' => '',
            'time' => 'nullable|date_format:j/n/Y g:i A',
        ];
        $data = $request->validate($rules);
        return $data;
    }
}
