<?php

namespace App\Exports;

use App\Models\Belances;
use Rap2hpoutre\FastExcel\FastExcel;

class BelancesExport
{
    protected $filters;

    public function __construct(array $filters = [])
    {
        $this->filters = $filters;
    }

    public function collection()
    {
        $query = Belances::with('type', 'account');

        // اعمال فیلترها
        if (!empty($this->filters['user_id'])) {
            $query->where('user_id', $this->filters['user_id']);
        }

        if (!empty($this->filters['type']) && $this->filters['type'] == 'debit') {
            $query->where('belance', '<', 0);
        }

        if (!empty($this->filters['type']) && $this->filters['type'] == 'credit') {
            $query->where('belance', '>=', 0);
        }

        if (!empty($this->filters['start_date'])) {
            $query->whereDate('date_created', '>=', $this->filters['start_date']);
        }

        if (!empty($this->filters['end_date'])) {
            $query->whereDate('date_created', '<=', $this->filters['end_date']);
        }

        $belances = $query->get();

        // گروه‌بندی بر اساس نوع کرنسی
        $grouped = $belances->groupBy(function ($item) {
            return $item->type ? $item->type->name : 'Unknown';
        });

        $result = collect();

        foreach ($grouped as $currency => $items) {
            // مرتب‌سازی هر گروه
            $items = $items->sortBy('id');

            $counter = 1; // شماره مسلسل برای هر کرنسی

            foreach ($items as $item) {
                $result->push([
                    'ID' => $counter++, // شماره مسلسل
                    'User Name' => $item->account ? $item->account->name : '',
                    'Currency' => $currency,
                    'Balance' => $item->belance,
                    'Created At' => $item->date_created,
                ]);
            }

            // اضافه کردن جمع کل هر کرنسی
            $result->push([
                'ID' => '',
                'User Name' => '',
                'Currency' => $currency . ' (Total)',
                'Balance' => $items->sum('belance'),
                'Created At' => '',
            ]);
        }

        return $result;
    }

    public function export($fileName = 'belances.xlsx')
    {
        $data = $this->collection();

        return (new FastExcel($data))->download($fileName);
    }
}
